/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.libvirt.VirtualMachineLauncher;
import hudson.plugins.libvirt.VirtualMachineSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMachineSlave
extends Slave {
    private static final Logger LOGGER = Logger.getLogger(VirtualMachineSlave.class.getName());
    private String hypervisorDescription;
    private String virtualMachineName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VirtualMachineSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, VirtualMachineLauncher launcher, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String hypervisorDescription, String virtualMachineName) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, Util.tryParseNumber((String)numExecutors, (Number)1).intValue(), mode, labelString, (ComputerLauncher)(launcher == null ? new VirtualMachineLauncher(delegateLauncher, hypervisorDescription, virtualMachineName) : launcher), retentionStrategy, nodeProperties);
        this.hypervisorDescription = hypervisorDescription;
        this.virtualMachineName = virtualMachineName;
    }

    public String getHypervisorDescription() {
        return this.hypervisorDescription;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public ComputerLauncher getDelegateLauncher() {
        return ((VirtualMachineLauncher)this.getLauncher()).getDelegate();
    }
}

