/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.libvirt.Domain;
import org.libvirt.DomainInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMachineLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(VirtualMachineLauncher.class.getName());
    private ComputerLauncher delegate;
    private transient VirtualMachine virtualMachine;
    private String hypervisorDescription;
    private String virtualMachineName;
    private static final int WAIT_TIME = 60000;
    @Extension
    public static final Descriptor<ComputerLauncher> DESCRIPTOR = new /* Unavailable Anonymous Inner Class!! */;

    @DataBoundConstructor
    public VirtualMachineLauncher(ComputerLauncher delegate, String hypervisorDescription, String virtualMachineName) {
        this.delegate = delegate;
        this.virtualMachineName = virtualMachineName;
        this.hypervisorDescription = hypervisorDescription;
        this.buildVirtualMachine();
    }

    private void buildVirtualMachine() {
        if (this.hypervisorDescription != null && this.virtualMachineName != null) {
            LOGGER.log(Level.INFO, "Building virtual machine object from names");
            Hypervisor hypervisor = null;
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof Hypervisor) || !((Hypervisor)cloud).getHypervisorDescription().equals(this.hypervisorDescription)) continue;
                hypervisor = (Hypervisor)cloud;
                break;
            }
            LOGGER.log(Level.INFO, "Hypervisor found... getting Virtual Machines associated");
            for (VirtualMachine vm : hypervisor.getVirtualMachines()) {
                if (!vm.getName().equals(this.virtualMachineName)) continue;
                this.virtualMachine = vm;
                break;
            }
        }
    }

    public ComputerLauncher getDelegate() {
        return this.delegate;
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public boolean isLaunchSupported() {
        return this.delegate.isLaunchSupported();
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        taskListener.getLogger().println("Getting connection to the virtual datacenter");
        if (this.virtualMachine == null) {
            taskListener.getLogger().println("No connection ready to the Hypervisor... reconnecting...");
            this.buildVirtualMachine();
        }
        try {
            Map computers = this.virtualMachine.getHypervisor().getDomains();
            taskListener.getLogger().println("Looking for the virtual machine on Hypervisor...");
            for (String domainName : computers.keySet()) {
                if (!this.virtualMachine.getName().equals(domainName)) continue;
                taskListener.getLogger().println("Virtual Machine Found");
                Domain domain = (Domain)computers.get(domainName);
                if (domain.getInfo().state != DomainInfo.DomainState.VIR_DOMAIN_BLOCKED && domain.getInfo().state != DomainInfo.DomainState.VIR_DOMAIN_RUNNING) {
                    taskListener.getLogger().println("Starting virtual machine");
                    domain.create();
                    taskListener.getLogger().println("Waiting 60000ms for machine startup");
                    Thread.sleep(60000L);
                } else {
                    taskListener.getLogger().println("Virtual machine is already running. No startup procedure required.");
                }
                taskListener.getLogger().println("Finished startup procedure... Connecting slave client");
                this.delegate.launch(slaveComputer, taskListener);
                return;
            }
            taskListener.getLogger().println("Error! Could not find virtual machine on the hypervisor");
            throw new IOException("VM not found!");
        }
        catch (IOException e) {
            e.printStackTrace(taskListener.getLogger());
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace(taskListener.getLogger());
            return;
        }
    }

    public void afterDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        taskListener.getLogger().println("Running disconnect procedure...");
        this.delegate.afterDisconnect(slaveComputer, taskListener);
        taskListener.getLogger().println("Shutting down Virtual Machine...");
        try {
            Map computers = this.virtualMachine.getHypervisor().getDomains();
            taskListener.getLogger().println("Looking for the virtual machine on Hypervisor...");
            for (String domainName : computers.keySet()) {
                if (!this.virtualMachine.getName().equals(domainName)) continue;
                Domain domain = (Domain)computers.get(domainName);
                taskListener.getLogger().println("Virtual Machine Found");
                if (domain.getInfo().state.equals((Object)DomainInfo.DomainState.VIR_DOMAIN_RUNNING) || domain.getInfo().state.equals((Object)DomainInfo.DomainState.VIR_DOMAIN_BLOCKED)) {
                    taskListener.getLogger().println("Shutting down virtual machine");
                    domain.shutdown();
                } else {
                    taskListener.getLogger().println("Virtual machine is already suspended. No shutdown procedure required.");
                }
                return;
            }
            taskListener.getLogger().println("Error! Could not find virtual machine on the hypervisor");
        }
        catch (Throwable t) {
            taskListener.fatalError(t.getMessage(), new Object[]{t});
        }
    }

    public void beforeDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        this.delegate.beforeDisconnect(slaveComputer, taskListener);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }
}

