/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.PwdCrypt;
import hudson.plugins.sctmexecutor.SCTMExecutor;
import hudson.tasks.Builder;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SCTMExecutorDescriptor
extends Descriptor<Builder> {
    private String serviceURL;
    private String user;
    private String password;

    SCTMExecutorDescriptor() {
        super(SCTMExecutor.class);
        this.load();
    }

    public String getDisplayName() {
        return Messages.getString((String)"SCTMExecutorDescriptor.plugin.title");
    }

    public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String execDefIds = req.getParameter("sctmexecutor.execDefId");
        String str = req.getParameter("sctmexecutor.projectId");
        int projectId = Integer.parseInt(str);
        return new SCTMExecutor(projectId, execDefIds);
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.serviceURL = req.getParameter("sctmexecutor.serviceURL");
        this.user = req.getParameter("sctmexecutor.user");
        try {
            this.password = PwdCrypt.encode((String)req.getParameter("sctmexecutor.password"), (String)Hudson.getInstance().getSecretKey());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.save();
        return super.configure(req, json);
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        try {
            return PwdCrypt.decode((String)this.password, (String)Hudson.getInstance().getSecretKey());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

