/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import com.borland.scc.sccsystem.SystemService;
import com.borland.scc.sccsystem.SystemServiceServiceLocator;
import com.borland.tm.webservices.tmexecution.ExecutionHandle;
import com.borland.tm.webservices.tmexecution.ExecutionWebService;
import com.borland.tm.webservices.tmexecution.ExecutionWebServiceServiceLocator;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.ResultCollectorThread;
import hudson.plugins.sctmexecutor.SCTMExecutorDescriptor;
import hudson.plugins.sctmexecutor.StdXMLResultWriter;
import hudson.tasks.Builder;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTMExecutor
extends Builder {
    public static final SCTMExecutorDescriptor DESCRIPTOR = new SCTMExecutorDescriptor();
    private final int projectId;
    private final String execDefIds;

    @DataBoundConstructor
    public SCTMExecutor(int projectId, String execDefIds) {
        this.projectId = projectId;
        this.execDefIds = execDefIds;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getExecDefIds() {
        return this.execDefIds;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String serviceURL = DESCRIPTOR.getServiceURL();
        try {
            SystemService systemService = new SystemServiceServiceLocator().getsccsystem(new URL(serviceURL + "/sccsystem?wsdl"));
            ExecutionWebService execService = new ExecutionWebServiceServiceLocator().gettmexecution(new URL(serviceURL + "/tmexecution?wsdl"));
            long sessionId = systemService.logonUser(DESCRIPTOR.getUser(), DESCRIPTOR.getPassword());
            listener.getLogger().println(Messages.getString("SCTMExecutor.log.successfulLogin"));
            execService.setCurrentProject(sessionId, this.projectId);
            ArrayList<ExecutionHandle> execHandles = new ArrayList<ExecutionHandle>();
            for (Integer execDefId : this.csvToIntList(this.execDefIds)) {
                ExecutionHandle[] execHandleArr = execService.startExecution(sessionId, execDefId);
                if (execHandleArr.length <= 0 || execHandleArr[0] == null || execHandleArr[0] != null && execHandleArr[0].getTimeStamp() <= 0L) {
                    listener.error(Messages.getString("SCTMExecutor.err.execDefNotFound", execDefId));
                    return false;
                }
                listener.getLogger().println(Messages.getString("SCTMExecutor.log.successfulStartExecution", execDefId));
                for (ExecutionHandle executionHandle : execHandleArr) {
                    execHandles.add(executionHandle);
                }
            }
            for (ExecutionHandle executionHandle : execHandles) {
                FilePath rootDir = build.getProject().getWorkspace();
                if (rootDir == null) {
                    listener.error("Cannot write the result file because slave is not connected.");
                    break;
                }
                if ((rootDir = new FilePath(rootDir, "SCTMResults")).exists()) {
                    rootDir.deleteRecursive();
                }
                rootDir.mkdirs();
                ResultCollectorThread resultCollector = new ResultCollectorThread(listener.getLogger(), execService, sessionId, executionHandle, new StdXMLResultWriter(rootDir));
                resultCollector.start();
                resultCollector.join();
            }
            return true;
        }
        catch (ServiceException e) {
            listener.error(Messages.getString("SCTMExecutor.err.wrongServiceURL"));
            return false;
        }
        catch (RemoteException e) {
            listener.error(Messages.getString("SCTMExecutor.err.sctm", e.getMessage()));
            return false;
        }
        catch (Exception e) {
            listener.error(Messages.getString("SCTMExecutor.err.pwdCryptFailed"));
            return false;
        }
    }

    private List<Integer> csvToIntList(String execDefIds) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (execDefIds.contains(",")) {
            String[] ids;
            for (String str : ids = execDefIds.split(",")) {
                list.add(Integer.valueOf(str));
            }
        } else {
            list.add(Integer.valueOf(execDefIds));
        }
        return list;
    }
}

