/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import com.borland.tm.webservices.tmexecution.ExecutionResult;
import com.borland.tm.webservices.tmexecution.TestDefinitionResult;
import hudson.FilePath;
import hudson.plugins.sctmexecutor.ITestResultWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class StdXMLResultWriter
implements ITestResultWriter {
    private static final int NOT_EXECUTED = 3;
    private static final int FAILED = 2;
    private FilePath rootDir;

    public StdXMLResultWriter(FilePath rootDir) {
        this.rootDir = rootDir;
    }

    public void write(ExecutionResult result) {
        int done = 3;
        String resultFileName = "TEST-" + result.getExecDefName();
        while (done > 0) {
            try {
                FilePath resultFile = this.rootDir.createTempFile(resultFileName, ".xml");
                OutputStream fos = resultFile.write();
                XMLSerializer serializer = new XMLSerializer(fos, new OutputFormat("XML", "UTF-8", true));
                ContentHandler handler = serializer.asContentHandler();
                handler.startDocument();
                this.writeTestSuite(handler, result);
                handler.endDocument();
                fos.close();
                done = 0;
            }
            catch (IOException e) {
                resultFileName = resultFileName + "[" + DateFormat.getDateTimeInstance(3, 3).format(new Date(System.currentTimeMillis())) + "]";
                if (--done > 0) continue;
                System.err.println("[ERROR] Cannot write result file.");
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeTestSuite(ContentHandler handler, ExecutionResult result) throws SAXException {
        int errors = 0;
        int failures = 0;
        double duration = 0.0;
        for (TestDefinitionResult testResult : result.getTestDefResult()) {
            if (testResult.getStatus() == 2) {
                ++failures;
            } else if (testResult.getStatus() == 3) {
                ++errors;
            }
            duration += (double)(testResult.getDuration() / 100);
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "errors", "CDATA", String.valueOf(errors));
        atts.addAttribute("", "", "failures", "CDATA", String.valueOf(failures));
        atts.addAttribute("", "", "hostname", "CDATA", result.getExecServerName());
        atts.addAttribute("", "", "name", "CDATA", result.getExecDefName());
        atts.addAttribute("", "", "time", "CDATA", String.valueOf(duration));
        atts.addAttribute("", "", "tests", "CDATA", String.valueOf(result.getTestDefResult().length));
        atts.addAttribute("", "", "timestamp", "CDATA", DateFormat.getDateTimeInstance(3, 3).format(new Date(System.currentTimeMillis())));
        handler.startElement("", "", "testsuite", atts);
        for (TestDefinitionResult testResult : result.getTestDefResult()) {
            this.writeTestResult(handler, testResult);
        }
        handler.endElement("", "", "testsuite");
    }

    private void writeTestResult(ContentHandler handler, TestDefinitionResult testResult) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "classname", "CDATA", testResult.getName());
        atts.addAttribute("", "", "name", "CDATA", testResult.getName() + "#test");
        atts.addAttribute("", "", "time", "CDATA", String.valueOf(testResult.getDuration() / 100));
        handler.startElement("", "", "testcase", atts);
        if (testResult.getStatus() == 2) {
            this.writeFailure(handler, testResult.getResultURL());
        } else if (testResult.getStatus() == 3) {
            this.writeError(handler, testResult.getResultURL());
        }
        handler.endElement("", "", "testcase");
    }

    private void writeError(ContentHandler handler, String resultURL) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "message", "CDATA", resultURL);
        atts.addAttribute("", "", "type", "CDATA", "SCTMError");
        handler.startElement("", "", "error", atts);
        handler.endElement("", "", "error");
    }

    private void writeFailure(ContentHandler handler, String resultURL) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "message", "CDATA", resultURL);
        atts.addAttribute("", "", "type", "CDATA", "SCTMFailure");
        handler.startElement("", "", "failure", atts);
        handler.endElement("", "", "failure");
    }
}

