/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import com.borland.tm.webservices.tmexecution.ExecutionHandle;
import com.borland.tm.webservices.tmexecution.ExecutionResult;
import com.borland.tm.webservices.tmexecution.ExecutionWebService;
import hudson.plugins.sctmexecutor.ITestResultWriter;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;

public class ResultCollectorThread
extends Thread {
    private ExecutionHandle handle;
    private ExecutionWebService service;
    private long sessionId;
    private long sleep = 10000L;
    private ITestResultWriter writer;
    private PrintStream logger;

    public ResultCollectorThread(PrintStream logger, ExecutionWebService service, long sessionId, ExecutionHandle handle, ITestResultWriter writer) {
        super("SCTMExecutor.resultcollector" + handle.getExecDefId());
        this.logger = logger;
        this.handle = handle;
        this.service = service;
        this.sessionId = sessionId;
        this.writer = writer;
    }

    public void setSleep(long sleep) {
        this.sleep = sleep;
    }

    public void run() {
        ExecutionResult result = null;
        try {
            Thread.sleep(5000L);
            while (result == null) {
                int stateOfExecution = this.service.getStateOfExecution(this.sessionId, this.handle);
                if (stateOfExecution == -1) {
                    result = this.service.getExecutionResult(this.sessionId, this.handle);
                    this.logger.println(MessageFormat.format("Received result for execution definition {0}.", this.handle.getExecDefId()));
                    continue;
                }
                Thread.sleep(this.sleep);
            }
            this.writer.write(result);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Collecting results failed: ", e);
        }
        catch (InterruptedException e) {
            this.interrupt();
            throw new RuntimeException("Collecting result aborted: ", e);
        }
    }
}

