/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import com.borland.tm.webservices.tmexecution.ExecutionHandle;
import com.borland.tm.webservices.tmexecution.ExecutionResult;
import com.borland.tm.webservices.tmexecution.ExecutionWebService;
import hudson.plugins.sctmexecutor.ITestResultWriter;
import hudson.plugins.sctmexecutor.Messages;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ResultCollectorThread
extends Thread {
    private static final int MAX_SLEEP = 60;
    private static final int MAX_RETRIES = 2;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmexecutor");
    private ExecutionHandle handle;
    private ExecutionWebService service;
    private long sessionId;
    private long sleep = 5L;
    private ITestResultWriter writer;
    private PrintStream consolenLogger;
    private int retries;

    public ResultCollectorThread(PrintStream logger, ExecutionWebService service, long sessionId, ExecutionHandle handle, ITestResultWriter writer) {
        super("SCTMExecutor.resultcollector" + handle.getExecDefId());
        this.consolenLogger = logger;
        this.handle = handle;
        this.service = service;
        this.sessionId = sessionId;
        this.writer = writer;
    }

    void setSleep(long sleep) {
        this.sleep = sleep;
    }

    public void run() {
        ExecutionResult result = null;
        int stateOfExecution = -2;
        try {
            do {
                Thread.sleep(this.sleep * 1000L);
                stateOfExecution = this.service.getStateOfExecution(this.sessionId, this.handle);
                if (stateOfExecution == -1) {
                    result = this.service.getExecutionResult(this.sessionId, this.handle);
                    this.consolenLogger.println(MessageFormat.format(Messages.getString((String)"ResultCollectorThread.log.resultReceived"), this.handle.getExecDefId()));
                    continue;
                }
                if (this.sleep >= 60L) continue;
                this.sleep *= 2L;
                if (this.sleep <= 60L) continue;
                this.sleep = 60L;
            } while (result == null);
            this.writer.write(result);
        }
        catch (RemoteException e) {
            if (stateOfExecution == -1 && this.retries < 2) {
                ++this.retries;
                LOGGER.log(Level.WARNING, MessageFormat.format("Execution should be finished, but it is no result available for execution definition {0}. Try again {1}!", this.handle.getExecDefId(), this.retries));
                this.run();
            }
            LOGGER.log(Level.SEVERE, "Remote call to SCTM failed during result collection.");
            LOGGER.log(Level.INFO, e.getMessage());
            throw new RuntimeException(Messages.getString((String)"ResultCollectorThread.err.collectingResultFailed"), e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Collecting results aborted.");
            LOGGER.log(Level.INFO, e.getMessage());
            this.interrupt();
            throw new RuntimeException(Messages.getString((String)"ResultCollectorThread.err.collectionResultAborted"), e);
        }
    }
}

