/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.PwdCrypt;
import hudson.plugins.sctmexecutor.SCTMExecutor;
import hudson.tasks.Builder;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SCTMExecutorDescriptor
extends Descriptor<Builder> {
    private String serviceURL;
    private String user;
    private String password;

    SCTMExecutorDescriptor() {
        super(SCTMExecutor.class);
        this.load();
    }

    public String getDisplayName() {
        return Messages.getString("SCTMExecutorDescriptor.plugin.title");
    }

    public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String execDefIds = formData.getString("execDefId");
        String str = formData.getString("projectId");
        int projectId = Integer.parseInt(str);
        return new SCTMExecutor(projectId, execDefIds);
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.serviceURL = json.getString("serviceURL");
        this.user = json.getString("user");
        this.password = PwdCrypt.encode(json.getString("password"), Hudson.getInstance().getSecretKey());
        this.save();
        return super.configure(req, json);
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return PwdCrypt.decode(this.password, Hudson.getInstance().getSecretKey());
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void doTestConnection(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="serviceURL") String serviceURL, @QueryParameter(value="user") String user) throws IOException, ServletException {
        System.out.println("test connection");
    }

    public void doCheckProjectId(StaplerRequest req, StaplerResponse rsp) {
        System.out.println("checked");
    }
}

