/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import com.borland.tm.webservices.tmexecution.ExecutionHandle;
import com.borland.tm.webservices.tmexecution.ExecutionResult;
import com.borland.tm.webservices.tmexecution.ExecutionWebService;
import hudson.plugins.sctmexecutor.ISessionHandler;
import hudson.plugins.sctmexecutor.ITestResultWriter;
import hudson.plugins.sctmexecutor.Messages;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ResultCollectorThread
implements Runnable {
    private static final int MAX_SLEEP = 60;
    private static final int MAX_RETRIES = 2;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmexecutor");
    private ExecutionHandle handle;
    private ExecutionWebService execService;
    private long sleep = 5L;
    private ITestResultWriter writer;
    private PrintStream consolenLogger;
    private int retries;
    private ISessionHandler sessionHandler;

    public ResultCollectorThread(PrintStream logger, ExecutionWebService service, ISessionHandler sessionHandler, ExecutionHandle handle, ITestResultWriter writer) {
        this.consolenLogger = logger;
        this.handle = handle;
        this.execService = service;
        this.sessionHandler = sessionHandler;
        this.writer = writer;
    }

    void setSleep(long sleep) {
        this.sleep = sleep;
    }

    public void run() {
        ExecutionResult result = null;
        int stateOfExecution = -2;
        long sessionId = -1L;
        try {
            sessionId = this.sessionHandler.getSessionId(sessionId);
            do {
                Thread.sleep(this.sleep * 1000L);
                stateOfExecution = this.execService.getStateOfExecution(sessionId, this.handle);
                if (stateOfExecution == -1) {
                    result = this.execService.getExecutionResult(sessionId, this.handle);
                    this.consolenLogger.println(MessageFormat.format(Messages.getString("ResultCollectorThread.log.resultReceived"), this.handle.getExecDefId()));
                    continue;
                }
                if (this.sleep >= 60L) continue;
                this.sleep *= 2L;
                if (this.sleep <= 60L) continue;
                this.sleep = 60L;
            } while (result == null);
            this.writer.write(result);
        }
        catch (RemoteException e) {
            if (stateOfExecution == -1 && this.retries < 2) {
                ++this.retries;
                this.consolenLogger.println(MessageFormat.format(Messages.getString("ResultCollectorThread.wrn.execFinishedButNoResult"), this.handle.getExecDefId(), this.retries));
                this.run();
            }
            if (e.getMessage().contains("Not logged in.")) {
                LOGGER.log(Level.INFO, "Session lost - open new session by new login and try once more.");
                try {
                    sessionId = this.sessionHandler.getSessionId(sessionId);
                }
                catch (RemoteException e1) {
                    LOGGER.log(Level.INFO, e.getMessage());
                    throw new RuntimeException("Collecting results failed: ", e);
                }
                this.run();
            }
            LOGGER.log(Level.SEVERE, "Remote call to SCTM failed during result collection.");
            LOGGER.log(Level.INFO, e.getMessage());
            throw new RuntimeException("Collecting results failed: ", e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Collecting results aborted.");
            LOGGER.log(Level.INFO, e.getMessage());
            throw new RuntimeException("Collecting result aborted: ", e);
        }
    }
}

