/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import com.borland.scc.sccsystem.SystemService;
import com.borland.scc.sccsystem.SystemServiceServiceLocator;
import com.borland.tm.webservices.tmexecution.ExecutionHandle;
import com.borland.tm.webservices.tmexecution.ExecutionWebService;
import com.borland.tm.webservices.tmexecution.ExecutionWebServiceServiceLocator;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.sctmexecutor.ISessionHandler;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.ResultCollectorThread;
import hudson.plugins.sctmexecutor.SCTMExecutorDescriptor;
import hudson.plugins.sctmexecutor.SessionHandler;
import hudson.plugins.sctmexecutor.StdXMLResultWriter;
import hudson.plugins.sctmexecutor.exceptions.EncryptionException;
import hudson.tasks.Builder;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTMExecutor
extends Builder {
    public static final SCTMExecutorDescriptor DESCRIPTOR = new SCTMExecutorDescriptor();
    private static final Logger LOGGER = Logger.getLogger("hudson.plumgins.sctmexecutor");
    private static int resultNoForLastBuild = 0;
    private final int projectId;
    private final String execDefIds;

    @DataBoundConstructor
    public SCTMExecutor(int projectId, String execDefIds) {
        this.projectId = projectId;
        this.execDefIds = execDefIds;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getExecDefIds() {
        return this.execDefIds;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String serviceURL = DESCRIPTOR.getServiceURL();
        try {
            List<ExecutionHandle> execHandles;
            SystemService systemService = new SystemServiceServiceLocator().getsccsystem(new URL(serviceURL + "/sccsystem?wsdl"));
            ExecutionWebService execService = new ExecutionWebServiceServiceLocator().gettmexecution(new URL(serviceURL + "/tmexecution?wsdl"));
            SessionHandler sessionHandler = new SessionHandler(systemService, DESCRIPTOR.getUser(), DESCRIPTOR.getPassword());
            long sessionId = sessionHandler.getSessionId(-1L);
            listener.getLogger().println(Messages.getString("SCTMExecutor.log.successfulLogin"));
            execService.setCurrentProject(sessionId, this.projectId);
            try {
                execHandles = this.startExecutions(listener, execService, sessionId);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            this.collectResults(build, listener, execService, sessionHandler, execHandles);
            return true;
        }
        catch (ServiceException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            listener.error(MessageFormat.format(Messages.getString("SCTMExecutor.err.urlOrServiceBroken"), serviceURL));
            return false;
        }
        catch (RemoteException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            listener.error(Messages.getString("SCTMExecutor.err.accessDenied"));
            return false;
        }
        catch (EncryptionException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            listener.error(MessageFormat.format("{0} {1}", Messages.getString("SCTMExecutor.log.unknownError"), e.getLocalizedMessage()));
            return false;
        }
    }

    private void collectResults(AbstractBuild<?, ?> build, BuildListener listener, ExecutionWebService execService, ISessionHandler sessionHandler, List<ExecutionHandle> execHandles) throws IOException, InterruptedException, ExecutionException {
        FilePath rootDir = build.getProject().getWorkspace();
        if (rootDir == null) {
            LOGGER.log(Level.SEVERE, "Cannot write the result file because slave is not connected.");
            listener.error(Messages.getString("SCTMExecutor.log.slaveNotConnected"));
        }
        rootDir = SCTMExecutor.createResultDir(rootDir, build.number);
        ExecutorService tp = DESCRIPTOR.getExecutorPool();
        ArrayList results = new ArrayList(execHandles.size());
        for (ExecutionHandle executionHandle : execHandles) {
            ResultCollectorThread resultCollector = new ResultCollectorThread(listener.getLogger(), execService, sessionHandler, executionHandle, new StdXMLResultWriter(rootDir, DESCRIPTOR.getServiceURL()));
            results.add(tp.submit(resultCollector));
        }
        for (Future future : results) {
            future.get();
        }
    }

    private List<ExecutionHandle> startExecutions(BuildListener listener, ExecutionWebService execService, long sessionId) throws RemoteException {
        ArrayList<ExecutionHandle> execHandles = new ArrayList<ExecutionHandle>();
        for (Integer execDefId : this.csvToIntList(this.execDefIds)) {
            ExecutionHandle[] execHandleArr = execService.startExecution(sessionId, execDefId);
            if (execHandleArr.length <= 0 || execHandleArr[0] == null || execHandleArr[0] != null && execHandleArr[0].getTimeStamp() <= 0L) {
                listener.error(Messages.getString(Messages.getString("SCTMExecutor.err.execDefNotFound"), execDefId));
                throw new IllegalArgumentException();
            }
            listener.getLogger().println(MessageFormat.format(Messages.getString("SCTMExecutor.log.successfulStartExecution"), execDefId));
            for (ExecutionHandle executionHandle : execHandleArr) {
                execHandles.add(executionHandle);
            }
        }
        return execHandles;
    }

    private static FilePath createResultDir(FilePath rootDir, int currentBuildNo) throws IOException, InterruptedException {
        rootDir = new FilePath(rootDir, "SCTMResults");
        if (resultNoForLastBuild != currentBuildNo) {
            if (rootDir.exists()) {
                rootDir.deleteRecursive();
            }
            rootDir.mkdirs();
            resultNoForLastBuild = currentBuildNo;
        }
        return rootDir;
    }

    private List<Integer> csvToIntList(String execDefIds) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (execDefIds.contains(",")) {
            String[] ids;
            for (String str : ids = execDefIds.split(",")) {
                list.add(Integer.valueOf(str));
            }
        } else {
            list.add(Integer.valueOf(execDefIds));
        }
        return list;
    }
}

