/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.PwdCrypt;
import hudson.plugins.sctmexecutor.SCTMExecutor;
import hudson.plugins.sctmexecutor.validators.EmptySingleFieldValidator;
import hudson.plugins.sctmexecutor.validators.NumberCSVSingleFieldValidator;
import hudson.plugins.sctmexecutor.validators.TestConnectionValidator;
import hudson.tasks.Builder;
import hudson.util.FormFieldValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SCTMExecutorDescriptor
extends Descriptor<Builder> {
    private String serviceURL;
    private String user;
    private String password;
    private ExecutorService threadPool;

    SCTMExecutorDescriptor() {
        super(SCTMExecutor.class);
        this.load();
    }

    public String getDisplayName() {
        return Messages.getString("SCTMExecutorDescriptor.plugin.title");
    }

    public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String execDefIds = formData.getString("execDefIds");
        String str = formData.getString("projectId");
        int projectId = Integer.parseInt(str);
        return new SCTMExecutor(projectId, execDefIds);
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.serviceURL = json.getString("serviceURL");
        this.user = json.getString("user");
        this.password = PwdCrypt.encode(json.getString("password"), Hudson.getInstance().getSecretKey());
        this.save();
        return super.configure(req, json);
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        if (this.password != null && !this.password.equals("")) {
            return PwdCrypt.decode(this.password, Hudson.getInstance().getSecretKey());
        }
        return "";
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void doCheckServiceURL(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="value") String value) throws IOException, ServletException {
        new FormFieldValidator.URLCheck(req, rsp){

            protected void check() throws IOException, ServletException {
                if (value == null || value != null && !value.matches("http(s)?://(((\\d{1,3}.){3}\\d{1,3})?|([\\p{Alnum}-_.])*)(:\\d{0,5})?(/([\\p{Alnum}-_.])*)?/services")) {
                    this.error(Messages.getString("SCTMUrlValidator.msg.noValidURL"));
                    return;
                }
                try {
                    URL url = new URL(value);
                    BufferedReader reader = this.open(url);
                    if (this.findText(reader, "tmexecution")) {
                        this.ok();
                    } else {
                        this.warning(Messages.getString("SCTMURL.Validator.msg.noServiceFound"));
                    }
                }
                catch (IOException e) {
                    this.handleIOException(value, e);
                }
                catch (IllegalArgumentException e) {
                    this.error(Messages.getString("SCTMUrlValidator.msg.noValidURL"));
                }
            }
        }.process();
    }

    public void doCheckUser(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) throws IOException, ServletException {
        new EmptySingleFieldValidator(value).process();
    }

    public void doCheckPassword(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) throws IOException, ServletException {
        new EmptySingleFieldValidator(value).process();
    }

    public void doCheckExecDefIds(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) throws IOException, ServletException {
        new NumberCSVSingleFieldValidator(value).process();
    }

    public void doCheckProjectId(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) throws IOException, ServletException {
        new FormFieldValidator.NonNegativeInteger().process();
    }

    public void doTestConnection(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="serviceURL") String serviceURL, @QueryParameter(value="user") String user, @QueryParameter(value="password") String password) throws IOException, ServletException {
        new TestConnectionValidator(serviceURL, user, password).process();
    }

    public ExecutorService getExecutorPool() {
        if (this.threadPool == null || this.threadPool.isShutdown() || this.threadPool.isTerminated()) {
            this.threadPool = Executors.newFixedThreadPool(8);
        }
        return this.threadPool;
    }

    public void shutdown() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }
}

