/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import com.borland.tm.webservices.tmexecution.ExecutionResult;
import com.borland.tm.webservices.tmexecution.TestDefinitionResult;
import hudson.FilePath;
import hudson.plugins.sctmexecutor.ITestResultWriter;
import hudson.plugins.sctmexecutor.Messages;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class StdXMLResultWriter
implements ITestResultWriter {
    private static final int NOT_EXECUTED = 3;
    private static final int FAILED = 2;
    private static final String DEFAULT_SCTM_PACKAGENAME = "silkcentral.testmanager.";
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmexecutor");
    private String sctmHost;
    private FilePath rootDir;

    public StdXMLResultWriter(FilePath rootDir, String serviceURL) {
        this.rootDir = rootDir;
        this.sctmHost = serviceURL.substring(0, serviceURL.indexOf("/", "http://".length())) + "/silk/DEF";
    }

    public void write(ExecutionResult result) {
        int done = 3;
        String resultFileName = "TEST-" + result.getExecDefName();
        while (done > 0) {
            try {
                FilePath resultFile = this.rootDir.child(resultFileName + ".xml");
                OutputStream fos = resultFile.write();
                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(fos);
                writer.writeStartDocument();
                this.writeTestSuite(writer, result);
                writer.writeEndDocument();
                fos.close();
                done = 0;
            }
            catch (IOException e) {
                resultFileName = resultFileName + "[" + DateFormat.getDateTimeInstance(3, 3).format(new Date(System.currentTimeMillis())) + "]";
                if (--done > 0) continue;
                LOGGER.log(Level.SEVERE, "Cannot write result file.");
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
                done = 0;
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
                done = 0;
            }
            catch (FactoryConfigurationError e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
                done = 0;
            }
        }
    }

    private void writeTestSuite(XMLStreamWriter writer, ExecutionResult result) throws XMLStreamException {
        String execDefName = DEFAULT_SCTM_PACKAGENAME + result.getExecDefName();
        writer.writeStartElement("testsuite");
        this.writeTestSuiteCountAttributes(writer, result);
        writer.writeAttribute("hostname", result.getExecServerName());
        writer.writeAttribute("name", execDefName);
        writer.writeAttribute("timestamp", DateFormat.getDateTimeInstance(3, 3).format(new Date(System.currentTimeMillis())));
        TestDefinitionResult setupTestDef = result.getSetupTestDef();
        TestDefinitionResult cleanupTestDef = result.getCleanupTestDef();
        if (setupTestDef != null) {
            this.writeTestResult(writer, setupTestDef, execDefName);
        }
        for (TestDefinitionResult testResult : result.getTestDefResult()) {
            this.writeTestResult(writer, testResult, execDefName);
        }
        if (cleanupTestDef != null) {
            this.writeTestResult(writer, cleanupTestDef, execDefName);
        }
        writer.writeEndElement();
    }

    private void writeTestSuiteCountAttributes(XMLStreamWriter writer, ExecutionResult result) throws XMLStreamException {
        int errors = 0;
        int failures = 0;
        double duration = 0.0;
        for (TestDefinitionResult testResult : result.getTestDefResult()) {
            if (testResult.getStatus() == 2) {
                ++failures;
            } else if (testResult.getStatus() == 3) {
                ++errors;
            }
            duration += (double)(testResult.getDuration() / 1000);
        }
        TestDefinitionResult setupTestDef = result.getSetupTestDef();
        TestDefinitionResult cleanupTestDef = result.getCleanupTestDef();
        if (setupTestDef != null) {
            if (setupTestDef.getStatus() == 2) {
                ++failures;
            } else if (setupTestDef.getStatus() == 3) {
                ++failures;
            }
            duration += (double)(setupTestDef.getDuration() / 1000);
        }
        if (cleanupTestDef != null) {
            if (cleanupTestDef.getStatus() == 2) {
                ++failures;
            } else if (cleanupTestDef.getStatus() == 3) {
                ++failures;
            }
            duration += (double)(cleanupTestDef.getDuration() / 1000);
        }
        writer.writeAttribute("tests", String.valueOf(this.countTest(result)));
        writer.writeAttribute("errors", String.valueOf(errors));
        writer.writeAttribute("failures", String.valueOf(failures));
        writer.writeAttribute("time", String.valueOf(duration));
    }

    private int countTest(ExecutionResult result) {
        int testCount = result.getTestDefResult().length;
        if (result.getSetupTestDef() != null) {
            ++testCount;
        }
        if (result.getCleanupTestDef() != null) {
            ++testCount;
        }
        return testCount;
    }

    private void writeTestResult(XMLStreamWriter writer, TestDefinitionResult testResult, String testsuiteName) throws XMLStreamException {
        writer.writeStartElement("testcase");
        writer.writeAttribute("classname", testsuiteName);
        writer.writeAttribute("name", testResult.getName());
        writer.writeAttribute("time", String.valueOf(testResult.getDuration() / 1000));
        if (testResult.getStatus() == 2) {
            this.writeFailure(writer, testResult.getResultURL());
        } else if (testResult.getStatus() == 3) {
            this.writeError(writer, testResult.getResultURL());
        }
        writer.writeEndElement();
    }

    private void writeError(XMLStreamWriter writer, String resultURL) throws XMLStreamException {
        writer.writeStartElement("error");
        writer.writeAttribute("message", MessageFormat.format("{0}{1}", this.sctmHost, resultURL));
        writer.writeAttribute("type", "SCTMError");
        writer.writeEndElement();
    }

    private void writeFailure(XMLStreamWriter writer, String resultURL) throws XMLStreamException {
        writer.writeStartElement("failure");
        writer.writeAttribute("message", MessageFormat.format("{0}{1}", this.sctmHost, resultURL));
        writer.writeAttribute("type", Messages.getString("StdXMLResultWriter.testresult.failure"));
        writer.writeEndElement();
    }
}

