/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor.service;

import com.borland.tm.webservices.tmexecution.ExecutionHandle;
import com.borland.tm.webservices.tmexecution.ExecutionResult;
import hudson.plugins.sctmexecutor.exceptions.SCTMException;
import hudson.plugins.sctmexecutor.service.ISCTMService;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTMReRunProxy
implements ISCTMService {
    static final int MAXRERUN = 2;
    private ISCTMService target;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmexecutor.sctmservice");

    public SCTMReRunProxy(ISCTMService target) {
        this.target = target;
    }

    @Override
    public ExecutionResult getExecutionResult(ExecutionHandle handle) throws SCTMException {
        return this.doGetExecutionResult(handle, 2);
    }

    private ExecutionResult doGetExecutionResult(ExecutionHandle handle, int tryCount) throws SCTMException {
        try {
            return this.target.getExecutionResult(handle);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("Fetch result for execution definition {0} failed. {1}", handle.getExecDefId(), tryMore));
                return this.doGetExecutionResult(handle, --tryCount);
            }
            throw e;
        }
    }

    @Override
    public boolean isFinished(ExecutionHandle handle) throws SCTMException {
        return this.doIsFinished(handle, 2);
    }

    private boolean doIsFinished(ExecutionHandle handle, int tryCount) throws SCTMException {
        try {
            return this.target.isFinished(handle);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("Fetch state of execution for execution definition {0} failed. {1}", handle.getExecDefId(), tryMore));
                return this.doIsFinished(handle, --tryCount);
            }
            throw e;
        }
    }

    @Override
    public Collection<ExecutionHandle> start(int executionId) throws SCTMException {
        return this.doStart(executionId, 2);
    }

    private Collection<ExecutionHandle> doStart(int executionId, int tryCount) throws SCTMException {
        try {
            return this.target.start(executionId);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("Start execution for execution definition {0} failed. {1}", executionId, tryMore));
                return this.doStart(executionId, --tryCount);
            }
            throw e;
        }
    }

    @Override
    public Collection<ExecutionHandle> start(int executionId, String buildNumber) throws SCTMException {
        return this.doStart(executionId, buildNumber, 2);
    }

    private Collection<ExecutionHandle> doStart(int executionId, String buildNumber, int tryCount) throws SCTMException {
        try {
            return this.target.start(executionId, buildNumber);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("Start execution for execution definition {0} failed. {1}", executionId, tryMore));
                return this.doStart(executionId, buildNumber, --tryCount);
            }
            throw e;
        }
    }
}

