/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor.service;

import com.borland.scc.sccsystem.SystemService;
import com.borland.scc.sccsystem.SystemServiceServiceLocator;
import com.borland.tm.webservices.tmexecution.ExecutionHandle;
import com.borland.tm.webservices.tmexecution.ExecutionResult;
import com.borland.tm.webservices.tmexecution.ExecutionWebService;
import com.borland.tm.webservices.tmexecution.ExecutionWebServiceServiceLocator;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.exceptions.SCTMException;
import hudson.plugins.sctmexecutor.service.ISCTMService;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTMService
implements ISCTMService {
    private static final int MAX_LOGONRETRYCOUNT = 3;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmservice");
    private SystemService systemService;
    private ExecutionWebService execService;
    private long sessionId;
    private volatile int logonRetryCount;
    private String user;
    private String pwd;

    public SCTMService(String serviceURL, String user, String pwd) throws SCTMException {
        try {
            this.user = user;
            this.pwd = pwd;
            this.systemService = new SystemServiceServiceLocator().getsccsystem(new URL(serviceURL + "/sccsystem?wsdl"));
            this.execService = new ExecutionWebServiceServiceLocator().gettmexecution(new URL(serviceURL + "/tmexecution?wsdl"));
            this.sessionId = this.systemService.logonUser(this.user, this.pwd);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(Messages.getString("SCTMService.err.serviceUrlWrong"));
        }
        catch (ServiceException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString("SCTMService.err.urlOrServiceBroken"), serviceURL));
        }
        catch (RemoteException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString("SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    @Override
    public Collection<ExecutionHandle> start(int executionId) throws SCTMException {
        try {
            ExecutionHandle[] handles = this.execService.startExecution(this.sessionId, executionId);
            this.logonRetryCount = 0;
            return this.convertToList(handles);
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(executionId, e)) {
                return this.start(executionId);
            }
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString("SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    private boolean handleLostSessionException(int executionId, RemoteException e) throws SCTMException {
        if (e.getMessage().contains("Not logged in.") && this.logonRetryCount < 3) {
            ++this.logonRetryCount;
            LOGGER.warning(Messages.getString("SCTMService.warn.SessionLostReconnect"));
            try {
                this.sessionId = this.systemService.logonUser(this.user, this.pwd);
                return true;
            }
            catch (RemoteException e1) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                if (e.getMessage().contains("Not logged in")) {
                    throw new SCTMException(Messages.getString("SCTMService.err.accessDenied"));
                }
                throw new SCTMException(MessageFormat.format(Messages.getString("SCTMService.err.commonFatalError"), e.getMessage()));
            }
        }
        return false;
    }

    private Collection<ExecutionHandle> convertToList(ExecutionHandle[] handles) {
        ArrayList<ExecutionHandle> runs = new ArrayList<ExecutionHandle>(handles.length);
        for (ExecutionHandle handle : handles) {
            runs.add(handle);
        }
        return runs;
    }

    @Override
    public Collection<ExecutionHandle> start(int executionId, String buildNumber) throws SCTMException {
        try {
            ExecutionHandle[] handles = this.execService.startExecution(this.sessionId, executionId, buildNumber, 1, null);
            return this.convertToList(handles);
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(executionId, e)) {
                return this.start(executionId, buildNumber);
            }
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString("SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    @Override
    public boolean isFinished(ExecutionHandle handle) throws SCTMException {
        try {
            return this.execService.getStateOfExecution(this.sessionId, handle) < 0;
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(handle.getExecDefId(), e)) {
                return this.isFinished(handle);
            }
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString("SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    @Override
    public ExecutionResult getExecutionResult(ExecutionHandle handle) throws SCTMException {
        try {
            return this.execService.getExecutionResult(this.sessionId, handle);
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(handle.getExecDefId(), e)) {
                return this.getExecutionResult(handle);
            }
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString("SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }
}

