/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.plugins.sctmexecutor.ExecutionRunnable;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.SCTMExecutorDescriptor;
import hudson.plugins.sctmexecutor.StdXMLResultWriter;
import hudson.plugins.sctmexecutor.exceptions.SCTMException;
import hudson.plugins.sctmexecutor.service.SCTMReRunProxy;
import hudson.plugins.sctmexecutor.service.SCTMService;
import hudson.tasks.Builder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SCTMExecutor
extends Builder {
    static final int OPT_NO_BUILD_NUMBER = 1;
    static final int OPT_USE_THIS_BUILD_NUMBER = 2;
    static final int OPT_USE_UPSTREAMJOB_BUILDNUMBER = 3;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmexecutor");
    private final int projectId;
    private final String execDefIds;
    private final int delay;
    private final int buildNumberUsageOption;
    private final String upStreamJobName;
    private final boolean continueOnError;
    private final boolean collectResults;
    private boolean succeed;

    @DataBoundConstructor
    public SCTMExecutor(int projectId, String execDefIds, int delay, int buildNumberUsageOption, String upStreamJobName, boolean contOnErr, boolean collectResults) {
        this.projectId = projectId;
        this.execDefIds = execDefIds;
        this.delay = delay;
        this.buildNumberUsageOption = buildNumberUsageOption;
        this.upStreamJobName = upStreamJobName;
        this.continueOnError = contOnErr;
        this.collectResults = collectResults;
    }

    public SCTMExecutorDescriptor getDescriptor() {
        return (SCTMExecutorDescriptor)Hudson.getInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    public String getExecDefIds() {
        return this.execDefIds;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getBuildNumberUsageOption() {
        return this.buildNumberUsageOption;
    }

    public String getUpStreamJobName() {
        return this.upStreamJobName;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public String[] getUpStreamProjects() {
        Collection jobNames = Hudson.getInstance().getJobNames();
        return jobNames.toArray(new String[jobNames.size()]);
    }

    public boolean isCollectResults() {
        return this.collectResults;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SCTMExecutorDescriptor descriptor = (SCTMExecutorDescriptor)Hudson.getInstance().getDescriptor(((Object)((Object)this)).getClass());
        String serviceURL = descriptor.getServiceURL();
        try {
            SCTMReRunProxy service = new SCTMReRunProxy(new SCTMService(serviceURL, descriptor.getUser(), descriptor.getPassword()));
            listener.getLogger().println(Messages.getString("SCTMExecutor.log.successfulLogin"));
            FilePath rootDir = SCTMExecutor.createResultDir(build.number, build, listener);
            List<Integer> ids = this.csvToIntList(this.execDefIds);
            ArrayList results = new ArrayList(ids.size());
            for (Integer n : ids) {
                StdXMLResultWriter resultWriter = null;
                if (this.collectResults) {
                    resultWriter = new StdXMLResultWriter(rootDir, descriptor.getServiceURL(), String.valueOf(build.number));
                }
                ExecutionRunnable resultCollector = new ExecutionRunnable(service, n, this.getBuildNumber(build, listener), resultWriter, listener.getLogger());
                results.add(descriptor.getExecutorPool().submit(resultCollector));
                if (this.delay <= 0 || ids.size() <= 1) continue;
                Thread.sleep(this.delay * 1000);
            }
            for (Future future : results) {
                future.get();
            }
            this.succeed = true;
        }
        catch (SCTMException e) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("Creating a remote connection to SCTM host ({0}) failed.", serviceURL), e);
            listener.fatalError(e.getMessage());
            this.succeed = false;
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.SEVERE, "Starting or collecting for a SCTM execution failed.", e);
            listener.fatalError(MessageFormat.format(Messages.getString("SCTMExecutor.err.noResponseFromSCTM"), e.getMessage()));
            this.succeed = false;
        }
        return this.continueOnError || this.succeed;
    }

    private int getBuildNumber(AbstractBuild<?, ?> build, BuildListener listener) {
        if (3 == this.buildNumberUsageOption) {
            return this.getBuildNumberFromUpStreamProject(this.upStreamJobName, build.getUpstreamBuilds(), listener);
        }
        if (2 == this.buildNumberUsageOption) {
            return build.number;
        }
        return -1;
    }

    private int getBuildNumberFromUpStreamProject(String projectName, Map<AbstractProject, Integer> upstreamBuilds, BuildListener listener) {
        for (AbstractProject project : upstreamBuilds.keySet()) {
            if (!project.getName().equals(projectName)) continue;
            return upstreamBuilds.get(project);
        }
        listener.error(MessageFormat.format(Messages.getString("SCTMExecutor.err.notAUpstreamJob"), projectName));
        return -1;
    }

    private static FilePath createResultDir(int currentBuildNo, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath rootDir = build.getProject().getWorkspace();
        if (rootDir == null) {
            LOGGER.severe("Cannot write the result file because slave is not connected.");
            listener.error(Messages.getString("SCTMExecutor.log.slaveNotConnected"));
            throw new RuntimeException();
        }
        if ((rootDir = new FilePath(rootDir, "SCTMResults")).exists()) {
            final String buildNo = String.valueOf(currentBuildNo);
            List list = rootDir.list(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().matches("TEST-(\\p{Print}*)-" + buildNo + ".xml");
                }
            });
            if (list.size() <= 0) {
                rootDir.deleteContents();
            }
        } else {
            rootDir.mkdirs();
        }
        return rootDir;
    }

    private List<Integer> csvToIntList(String execDefIds) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (execDefIds.contains(",")) {
            String[] ids;
            for (String str : ids = execDefIds.split(",")) {
                list.add(Integer.valueOf(str));
            }
        } else {
            list.add(Integer.valueOf(execDefIds));
        }
        return list;
    }
}

