/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.PwdCrypt;
import hudson.plugins.sctmexecutor.SCTMExecutor;
import hudson.plugins.sctmexecutor.validators.EmptySingleFieldValidator;
import hudson.plugins.sctmexecutor.validators.NumberCSVSingleFieldValidator;
import hudson.plugins.sctmexecutor.validators.TestConnectionValidator;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SCTMExecutorDescriptor
extends BuildStepDescriptor<Builder> {
    private String serviceURL;
    private String user;
    private String password;
    private transient ExecutorService threadPool;

    public SCTMExecutorDescriptor() {
        super(SCTMExecutor.class);
        this.load();
    }

    public String getDisplayName() {
        return Messages.getString("SCTMExecutorDescriptor.plugin.title");
    }

    public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String execDefIds = formData.getString("execDefIds");
        int projectId = formData.getInt("projectId");
        int delay = this.getOptionalIntValue(formData.getString("delay"), 0);
        boolean contOnErr = formData.getBoolean("continueOnError");
        boolean collectResults = formData.getBoolean("collectResults");
        boolean ignoreSetupCleanup = formData.getBoolean("ignoreSetupCleanup");
        String jobName = "";
        return new SCTMExecutor(projectId, execDefIds, delay, 0, jobName, contOnErr, collectResults, ignoreSetupCleanup);
    }

    private int getOptionalIntValue(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.serviceURL = formData.getString("serviceURL");
        this.user = formData.getString("user");
        this.password = PwdCrypt.encode(formData.getString("password"), Hudson.getInstance().getSecretKey());
        this.save();
        return super.configure(req, formData);
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        if (this.password != null && !this.password.equals("")) {
            return PwdCrypt.decode(this.password, Hudson.getInstance().getSecretKey());
        }
        return "";
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public FormValidation doCheckServiceURL(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="value") String value) throws IOException, ServletException {
        return new FormValidation.URLCheck(){

            protected FormValidation check() throws IOException, ServletException {
                if (value == null || value != null && !value.matches("http(s)?://(((\\d{1,3}.){3}\\d{1,3})?|([\\p{Alnum}-_.])*)(:\\d{0,5})?(/([\\p{Alnum}-_.])*)?/services")) {
                    return FormValidation.error((String)Messages.getString("SCTMExecutorDescriptor.validate.msg.noValidURL"));
                }
                try {
                    URL url = new URL(value);
                    BufferedReader reader = this.open(url);
                    if (this.findText(reader, "tmexecution")) {
                        return FormValidation.ok();
                    }
                    return FormValidation.warning((String)Messages.getString("SCTMExecutorDescriptor.validate.msg.noServiceFound"));
                }
                catch (IOException e) {
                    return this.handleIOException(value, e);
                }
                catch (IllegalArgumentException e) {
                    return FormValidation.error((String)Messages.getString("SCTMExecutorDescriptor.validate.msg.noValidURL"));
                }
            }
        }.check();
    }

    public FormValidation doCheckUser(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return new EmptySingleFieldValidator().check(value);
    }

    public FormValidation doCheckPassword(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return new EmptySingleFieldValidator().check(value);
    }

    public FormValidation doCheckExecDefIds(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return new NumberCSVSingleFieldValidator().check(value);
    }

    public FormValidation doCheckProjectId(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    public FormValidation doCheckDelay(StaplerRequest rep, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    public FormValidation doTestConnection(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="serviceURL") String serviceURL, @QueryParameter(value="user") String user, @QueryParameter(value="password") String password) throws IOException, ServletException {
        return new TestConnectionValidator().check(serviceURL, user, password);
    }

    public ExecutorService getExecutorPool() {
        if (this.threadPool == null || this.threadPool.isShutdown() || this.threadPool.isTerminated()) {
            this.threadPool = Executors.newFixedThreadPool(8);
        }
        return this.threadPool;
    }

    public void shutdown() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return FreeStyleProject.class.equals(jobType);
    }
}

