/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.plugins.sctmexecutor.ExecutionRunnable;
import hudson.plugins.sctmexecutor.ITestResultWriter;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.SCTMExecutorDescriptor;
import hudson.plugins.sctmexecutor.StdXMLResultWriter;
import hudson.plugins.sctmexecutor.exceptions.SCTMException;
import hudson.plugins.sctmexecutor.service.ISCTMService;
import hudson.plugins.sctmexecutor.service.SCTMReRunProxy;
import hudson.plugins.sctmexecutor.service.SCTMService;
import hudson.tasks.Builder;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class SCTMExecutor
extends Builder {
    static final int OPT_NO_BUILD_NUMBER = 1;
    static final int OPT_USE_THIS_BUILD_NUMBER = 2;
    static final int OPT_USE_SPECIFICJOB_BUILDNUMBER = 3;
    static final int OPT_USE_LATEST_SCTM_BUILDNUMBER = 4;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmexecutor");
    private final int projectId;
    private final String execDefIds;
    private final int delay;
    private final int buildNumberUsageOption;
    private final String jobName;
    private final boolean continueOnError;
    private final boolean collectResults;
    private final boolean ignoreSetupCleanup;
    private boolean succeed;

    @DataBoundConstructor
    public SCTMExecutor(int projectId, String execDefIds, int delay, int buildNumberUsageOption, String jobName, boolean contOnErr, boolean collectResults, boolean ignoreSetupCleanup) {
        this.projectId = projectId;
        this.execDefIds = execDefIds;
        this.delay = delay;
        this.buildNumberUsageOption = buildNumberUsageOption;
        this.jobName = jobName;
        this.continueOnError = contOnErr;
        this.collectResults = collectResults;
        this.ignoreSetupCleanup = ignoreSetupCleanup;
    }

    public SCTMExecutorDescriptor getDescriptor() {
        return (SCTMExecutorDescriptor)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public String getExecDefIds() {
        return this.execDefIds;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getBuildNumberUsageOption() {
        return this.buildNumberUsageOption;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public boolean isignoreSetupCleanup() {
        return this.ignoreSetupCleanup;
    }

    public boolean isCollectResults() {
        return this.collectResults;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SCTMExecutorDescriptor descriptor = this.getDescriptor();
        String serviceURL = descriptor.getServiceURL();
        try {
            SCTMReRunProxy service = new SCTMReRunProxy((ISCTMService)new SCTMService(serviceURL, descriptor.getUser(), descriptor.getPassword(), this.projectId));
            listener.getLogger().println(Messages.getString((String)"SCTMExecutor.log.successfulLogin"));
            FilePath rootDir = SCTMExecutor.createResultDir((int)build.number, build, (BuildListener)listener);
            List ids = this.csvToIntList(this.execDefIds);
            ArrayList<Thread> executions = new ArrayList<Thread>(ids.size());
            for (Integer execDefId : ids) {
                StdXMLResultWriter resultWriter = null;
                if (this.collectResults) {
                    resultWriter = new StdXMLResultWriter(rootDir, descriptor.getServiceURL(), String.valueOf(build.number), this.ignoreSetupCleanup);
                }
                ExecutionRunnable resultCollector = new ExecutionRunnable((ISCTMService)service, execDefId.intValue(), this.getBuildNumber(build, listener, (ISCTMService)service, execDefId.intValue()), (ITestResultWriter)resultWriter, listener.getLogger());
                Thread t = new Thread((Runnable)resultCollector);
                executions.add(t);
                t.start();
                if (this.delay <= 0 || ids.size() <= 1) continue;
                Thread.sleep(this.delay * 1000);
            }
            for (Thread t : executions) {
                t.join();
            }
            this.succeed = true;
        }
        catch (SCTMException e) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("Creating a remote connection to SCTM host ({0}) failed.", serviceURL), e);
            listener.fatalError(e.getMessage());
            this.succeed = false;
        }
        return this.continueOnError || this.succeed;
    }

    private int getBuildNumber(AbstractBuild<?, ?> build, BuildListener listener, ISCTMService service, int nodeId) throws SCTMException {
        if (3 == this.buildNumberUsageOption) {
            return this.getBuildNumberFromUpStreamProject(this.jobName, build.getProject().getTransitiveUpstreamProjects(), listener);
        }
        if (2 == this.buildNumberUsageOption) {
            return build.number;
        }
        if (4 == this.buildNumberUsageOption) {
            return service.getLatestSCTMBuildnumber(nodeId);
        }
        return -1;
    }

    private int getBuildNumberFromUpStreamProject(String projectName, Set<AbstractProject> upstreamProjects, BuildListener listener) {
        for (AbstractProject project : upstreamProjects) {
            if (!project.getName().equals(projectName)) continue;
            return ((AbstractBuild)project.getLastSuccessfulBuild()).getNumber();
        }
        listener.error(MessageFormat.format(Messages.getString((String)"SCTMExecutor.err.notAUpstreamJob"), projectName));
        return -1;
    }

    private static FilePath createResultDir(int currentBuildNo, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath rootDir = build.getWorkspace();
        if (rootDir == null) {
            LOGGER.severe("Cannot write the result file because slave is not connected.");
            listener.error(Messages.getString((String)"SCTMExecutor.log.slaveNotConnected"));
            throw new RuntimeException();
        }
        if ((rootDir = new FilePath(rootDir, "SCTMResults")).exists()) {
            String buildNo = String.valueOf(currentBuildNo);
            List list = rootDir.list();
            if (list.size() > 0) {
                for (FilePath filePath : list) {
                    if (!filePath.getName().matches("TEST-(\\p{Print}*)-" + buildNo + ".xml")) continue;
                    return rootDir;
                }
                rootDir.deleteContents();
            }
        } else {
            rootDir.mkdirs();
        }
        return rootDir;
    }

    private List<Integer> csvToIntList(String execDefIds) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (execDefIds.contains(",")) {
            String[] ids;
            for (String str : ids = execDefIds.split(",")) {
                list.add(Integer.valueOf(str));
            }
        } else {
            list.add(Integer.valueOf(execDefIds));
        }
        return list;
    }
}

