/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.PwdCrypt;
import hudson.plugins.sctmexecutor.SCTMExecutor;
import hudson.plugins.sctmexecutor.validators.EmptySingleFieldValidator;
import hudson.plugins.sctmexecutor.validators.NumberCSVSingleFieldValidator;
import hudson.plugins.sctmexecutor.validators.TestConnectionValidator;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class SCTMExecutorDescriptor
extends BuildStepDescriptor<Builder> {
    private String serviceURL;
    private String user;
    private String password;

    public SCTMExecutorDescriptor() {
        super(SCTMExecutor.class);
        this.load();
    }

    public String getDisplayName() {
        return Messages.getString((String)"SCTMExecutorDescriptor.plugin.title");
    }

    public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String execDefIds = formData.getString("execDefIds");
        int projectId = formData.getInt("projectId");
        int delay = this.getOptionalIntValue(formData.getString("delay"), 0);
        boolean contOnErr = formData.getBoolean("continueOnError");
        boolean collectResults = formData.getBoolean("collectResults");
        boolean ignoreSetupCleanup = formData.getBoolean("ignoreSetupCleanup");
        String jobName = "";
        JSONObject buildNumberUsageOption = (JSONObject)formData.get("buildNumberUsageOption");
        int optValue = buildNumberUsageOption.getInt("value");
        if (optValue == 3) {
            jobName = buildNumberUsageOption.getString("jobName");
        }
        return new SCTMExecutor(projectId, execDefIds, delay, optValue, jobName, contOnErr, collectResults, ignoreSetupCleanup);
    }

    private int getOptionalIntValue(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.serviceURL = formData.getString("serviceURL");
        this.user = formData.getString("user");
        this.password = PwdCrypt.encode((String)formData.getString("password"), (String)Hudson.getInstance().getSecretKey());
        this.save();
        return super.configure(req, formData);
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        if (this.password != null && !this.password.equals("")) {
            return PwdCrypt.decode((String)this.password, (String)Hudson.getInstance().getSecretKey());
        }
        return "";
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public FormValidation doCheckServiceURL(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) throws IOException, ServletException {
        return new /* Unavailable Anonymous Inner Class!! */.check();
    }

    public Collection<String> getAllJobs() {
        return Hudson.getInstance().getJobNames();
    }

    public FormValidation doCheckUser(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return new EmptySingleFieldValidator().check(value);
    }

    public FormValidation doCheckPassword(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return new EmptySingleFieldValidator().check(value);
    }

    public FormValidation doCheckExecDefIds(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return new NumberCSVSingleFieldValidator().check(value);
    }

    public FormValidation doCheckProjectId(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    public FormValidation doCheckDelay(StaplerRequest rep, StaplerResponse rsp, @QueryParameter(value="value") String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    public FormValidation doTestConnection(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="serviceURL") String serviceURL, @QueryParameter(value="user") String user, @QueryParameter(value="password") String password) throws IOException, ServletException {
        return new TestConnectionValidator().check(serviceURL, user, password);
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return FreeStyleProject.class.equals(jobType);
    }
}

