/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor.service;

import com.borland.sctm.ws.execution.entities.ExecutionHandle;
import com.borland.sctm.ws.execution.entities.ExecutionResult;
import hudson.plugins.sctmexecutor.exceptions.SCTMException;
import hudson.plugins.sctmexecutor.service.ISCTMService;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTMReRunProxy
implements ISCTMService {
    static final int MAXRERUN = 2;
    private ISCTMService target;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmexecutor.sctmservice");

    public SCTMReRunProxy(ISCTMService target) {
        this.target = target;
    }

    public ExecutionResult getExecutionResult(ExecutionHandle handle) throws SCTMException {
        return this.doGetExecutionResult(handle, 2);
    }

    private ExecutionResult doGetExecutionResult(ExecutionHandle handle, int tryCount) throws SCTMException {
        try {
            return this.target.getExecutionResult(handle);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("Fetch result for execution definition {0} failed. {1}", handle.getExecDefId(), tryMore));
                return this.doGetExecutionResult(handle, --tryCount);
            }
            throw e;
        }
    }

    public boolean isFinished(ExecutionHandle handle) throws SCTMException {
        return this.doIsFinished(handle, 2);
    }

    private boolean doIsFinished(ExecutionHandle handle, int tryCount) throws SCTMException {
        try {
            return this.target.isFinished(handle);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("Fetch state of execution for execution definition {0} failed. {1}", handle.getExecDefId(), tryMore));
                return this.doIsFinished(handle, --tryCount);
            }
            throw e;
        }
    }

    public Collection<ExecutionHandle> start(int executionId) throws SCTMException {
        return this.doStart(executionId, 2);
    }

    private Collection<ExecutionHandle> doStart(int executionId, int tryCount) throws SCTMException {
        try {
            return this.target.start(executionId);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("Start execution for execution definition {0} failed. {1}", executionId, tryMore));
                return this.doStart(executionId, --tryCount);
            }
            throw e;
        }
    }

    public Collection<ExecutionHandle> start(int executionId, String buildNumber) throws SCTMException {
        return this.doStart(executionId, buildNumber, 2);
    }

    private Collection<ExecutionHandle> doStart(int executionId, String buildNumber, int tryCount) throws SCTMException {
        try {
            return this.target.start(executionId, buildNumber);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("Start execution for execution definition {0} failed. {1}", executionId, tryMore));
                return this.doStart(executionId, buildNumber, --tryCount);
            }
            throw e;
        }
    }

    public boolean addBuildNumber(int buildNumber, int nodeId) throws SCTMException {
        return this.doAddBuildNumber(buildNumber, nodeId, 2);
    }

    private boolean doAddBuildNumber(int buildNumber, int nodeId, int tryCount) throws SCTMException {
        try {
            return this.target.addBuildNumber(buildNumber, nodeId);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("BuildNumber ''{0}'' cannot be added. {1}", buildNumber, tryMore));
                return this.doAddBuildNumber(buildNumber, nodeId, --tryCount);
            }
            throw e;
        }
    }

    public boolean buildNumberExists(int buildNumber, int nodeId) throws SCTMException {
        return this.doBuildNumberExists(buildNumber, nodeId, 2);
    }

    private boolean doBuildNumberExists(int buildNumber, int nodeId, int tryCount) throws SCTMException {
        try {
            return this.target.buildNumberExists(buildNumber, nodeId);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("BuildNumber ''{0}'' cannot be added. {1}", buildNumber, tryMore));
                return this.doBuildNumberExists(buildNumber, nodeId, --tryCount);
            }
            throw e;
        }
    }

    public int getLatestSCTMBuildnumber(int nodeId) throws SCTMException {
        return this.doGetLatestSCTMBuildnumber(nodeId, 2);
    }

    private int doGetLatestSCTMBuildnumber(int nodeId, int tryCount) throws SCTMException {
        try {
            return this.target.getLatestSCTMBuildnumber(nodeId);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("No BuildNumber available on SCTM. {0}", tryMore));
                return this.doGetLatestSCTMBuildnumber(nodeId, --tryCount);
            }
            throw e;
        }
    }

    public String getExecDefinitionName(int execDefId) throws SCTMException {
        return this.doGetExecDefinitionName(execDefId, 2);
    }

    private String doGetExecDefinitionName(int nodeId, int tryCount) throws SCTMException {
        try {
            return this.target.getExecDefinitionName(nodeId);
        }
        catch (SCTMException e) {
            if (tryCount > 0) {
                String tryMore = "";
                if (tryCount > 1) {
                    tryMore = "Try once more.";
                }
                LOGGER.log(Level.WARNING, MessageFormat.format("No BuildNumber available on SCTM. {0}", tryMore));
                return this.doGetExecDefinitionName(nodeId, --tryCount);
            }
            throw e;
        }
    }
}

