/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor;

import com.borland.sctm.ws.execution.entities.ExecutionHandle;
import com.borland.sctm.ws.execution.entities.ExecutionResult;
import hudson.plugins.sctmexecutor.ITestResultWriter;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.exceptions.SCTMException;
import hudson.plugins.sctmexecutor.service.ISCTMService;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ExecutionRunnable
implements Runnable {
    private static final int MAX_SLEEP = 60;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmexecutor");
    private final int buildNumber;
    private final int execDefId;
    private final ISCTMService service;
    private final ITestResultWriter writer;
    private final PrintStream consolenLogger;
    private long resultCollectingDelay = 5L;
    private String execDefName;

    ExecutionRunnable(ISCTMService service, int execDefId, int buildNumber, ITestResultWriter writer, PrintStream logger) {
        this.consolenLogger = logger;
        this.execDefId = execDefId;
        this.writer = writer;
        this.service = service;
        this.buildNumber = buildNumber;
    }

    void setResultCollectingDelay(long sleep) {
        this.resultCollectingDelay = sleep;
    }

    public void run() {
        try {
            Collection<ExecutionHandle> handles;
            this.execDefName = this.service.getExecDefinitionName(this.execDefId);
            this.consolenLogger.println(MessageFormat.format(Messages.getString("ExecutionRunnable.msg.startExecDef"), this.execDefName, this.execDefId));
            if (this.buildNumber <= 0) {
                handles = this.service.start(this.execDefId);
            } else if (!this.service.buildNumberExists(this.buildNumber, this.execDefId)) {
                if (this.service.addBuildNumber(this.buildNumber, this.execDefId)) {
                    handles = this.service.start(this.execDefId, String.valueOf(this.buildNumber));
                } else {
                    LOGGER.warning(MessageFormat.format("Cannot add the new buildnumber ({0}). Ensure if the configured user ha enought rights. Go forward and start execution without explicit buildnumber.", this.buildNumber));
                    handles = this.service.start(this.execDefId);
                }
            } else {
                handles = this.service.start(this.execDefId, String.valueOf(this.buildNumber));
            }
            if (this.writer != null) {
                for (ExecutionHandle executionHandle : handles) {
                    this.collectExecutionResult(executionHandle);
                }
            }
        }
        catch (SCTMException e) {
            this.consolenLogger.println(MessageFormat.format(Messages.getString("ExecutionRunnable.err.startExecDefFailed"), this.execDefName, this.execDefId, e.getMessage()));
        }
    }

    private void collectExecutionResult(ExecutionHandle handle) {
        ExecutionResult result = null;
        try {
            this.consolenLogger.println(MessageFormat.format(Messages.getString("ExecutionRunnable.msg.waitForResult"), this.execDefName, handle.getExecDefId()));
            do {
                Thread.sleep(this.resultCollectingDelay * 1000L);
                if (this.service.isFinished(handle)) {
                    result = this.service.getExecutionResult(handle);
                    this.consolenLogger.println(MessageFormat.format(Messages.getString("ExecutionRunnable.log.resultReceived"), this.execDefName, handle.getExecDefId()));
                    continue;
                }
                if (this.resultCollectingDelay >= 60L) continue;
                this.resultCollectingDelay *= 2L;
                if (this.resultCollectingDelay <= 60L) continue;
                this.resultCollectingDelay = 60L;
            } while (result == null);
            this.writer.write(result);
        }
        catch (SCTMException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
            if (e.getMessage().contains("Logon failed.")) {
                this.consolenLogger.println(MessageFormat.format(Messages.getString("ExecutionRunnable.err.sessionLost"), e.getMessage()));
            } else {
                this.consolenLogger.println(MessageFormat.format(Messages.getString("ExecutionRunnable.err.collectingResultsFailed"), this.execDefName, handle.getExecDefId(), e.getMessage()));
            }
        }
        catch (InterruptedException e) {
            this.consolenLogger.println(MessageFormat.format(Messages.getString("ExecutionRunnable.warn.abortCollectingResults"), this.execDefName, handle.getExecDefId()));
            LOGGER.log(Level.INFO, e.getMessage());
        }
    }
}

