/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sctmexecutor.service;

import com.borland.sctm.ws.administration.MainEntities;
import com.borland.sctm.ws.administration.MainEntitiesServiceLocator;
import com.borland.sctm.ws.execution.ExecutionWebService;
import com.borland.sctm.ws.execution.ExecutionWebServiceServiceLocator;
import com.borland.sctm.ws.execution.entities.ExecutionHandle;
import com.borland.sctm.ws.execution.entities.ExecutionNode;
import com.borland.sctm.ws.execution.entities.ExecutionResult;
import com.borland.sctm.ws.execution.entities.PropertyValue;
import com.borland.sctm.ws.logon.SystemService;
import com.borland.sctm.ws.logon.SystemServiceServiceLocator;
import com.borland.sctm.ws.planning.PlanningService;
import com.borland.sctm.ws.planning.PlanningServiceServiceLocator;
import hudson.plugins.sctmexecutor.Messages;
import hudson.plugins.sctmexecutor.exceptions.SCTMException;
import hudson.plugins.sctmexecutor.service.ISCTMService;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTMService
implements ISCTMService {
    private static final int MAX_LOGONRETRYCOUNT = 3;
    private static final Logger LOGGER = Logger.getLogger("hudson.plugins.sctmservice");
    private SystemService systemService;
    private ExecutionWebService execService;
    private MainEntities adminService;
    private PlanningService planningService;
    private long sessionId;
    private volatile int logonRetryCount;
    private String user;
    private String pwd;

    public SCTMService(String serviceURL, String user, String pwd, int projectId) throws SCTMException {
        try {
            this.user = user;
            this.pwd = pwd;
            this.systemService = new SystemServiceServiceLocator().getsccsystem(new URL(serviceURL + "/sccsystem?wsdl"));
            this.execService = new ExecutionWebServiceServiceLocator().gettmexecution(new URL(serviceURL + "/tmexecution?wsdl"));
            this.adminService = new MainEntitiesServiceLocator().getsccentities(new URL(serviceURL + "/sccentities?wsdl"));
            this.planningService = new PlanningServiceServiceLocator().gettmplanning(new URL(serviceURL + "/tmplanning?wsdl"));
            this.sessionId = this.systemService.logonUser(this.user, this.pwd);
            this.execService.setCurrentProject(this.sessionId, projectId);
            this.planningService.setCurrentProject(this.sessionId, String.valueOf(projectId));
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(Messages.getString((String)"SCTMService.err.serviceUrlWrong"));
        }
        catch (ServiceException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString((String)"SCTMService.err.urlOrServiceBroken"), serviceURL));
        }
        catch (RemoteException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString((String)"SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    public Collection<ExecutionHandle> start(int executionId) throws SCTMException {
        try {
            ExecutionHandle[] handles = this.execService.startExecution(this.sessionId, executionId);
            this.logonRetryCount = 0;
            return this.convertToList(handles);
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(e)) {
                return this.start(executionId);
            }
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString((String)"SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    private boolean handleLostSessionException(RemoteException e) throws SCTMException {
        if (this.lostSessionExceptionThrown(e) && this.logonRetryCount < 3) {
            ++this.logonRetryCount;
            LOGGER.warning(Messages.getString((String)"SCTMService.warn.SessionLostReconnect"));
            try {
                this.sessionId = this.systemService.logonUser(this.user, this.pwd);
                return true;
            }
            catch (RemoteException e1) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                if (e.getMessage().contains("Not logged in")) {
                    throw new SCTMException(Messages.getString((String)"SCTMService.err.accessDenied"));
                }
                throw new SCTMException(MessageFormat.format(Messages.getString((String)"SCTMService.err.commonFatalError"), e.getMessage()));
            }
        }
        return false;
    }

    private boolean lostSessionExceptionThrown(RemoteException e) {
        String message = e.getMessage();
        return message.contains("Not logged in.") || message.contains("InvalidSidException: sid") && message.contains("is invalid or expired");
    }

    private Collection<ExecutionHandle> convertToList(ExecutionHandle[] handles) {
        ArrayList<ExecutionHandle> runs = new ArrayList<ExecutionHandle>(handles.length);
        for (ExecutionHandle handle : handles) {
            runs.add(handle);
        }
        return runs;
    }

    public Collection<ExecutionHandle> start(int executionId, String buildNumber) throws SCTMException {
        try {
            ExecutionHandle[] handles = this.execService.startExecution(this.sessionId, executionId, buildNumber, 1, null);
            return this.convertToList(handles);
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(e)) {
                return this.start(executionId, buildNumber);
            }
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString((String)"SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    public boolean isFinished(ExecutionHandle handle) throws SCTMException {
        try {
            return this.execService.getStateOfExecution(this.sessionId, handle) < 0;
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(e)) {
                return this.isFinished(handle);
            }
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString((String)"SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    public ExecutionResult getExecutionResult(ExecutionHandle handle) throws SCTMException {
        try {
            return this.execService.getExecutionResult(this.sessionId, handle);
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(e)) {
                return this.getExecutionResult(handle);
            }
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString((String)"SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    public boolean addBuildNumber(int buildNumber, int nodeId) throws SCTMException {
        try {
            ExecutionNode node = this.execService.getNode(this.sessionId, nodeId);
            String version = this.getExecutionNodePropertyValue(node, "PROP_VERSIONNAME");
            String productName = this.getProductName(node);
            return this.adminService.addBuild(this.sessionId, productName, version, String.valueOf(buildNumber), "build number generated by hudson continuous integration system", true);
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(e)) {
                this.addBuildNumber(buildNumber, nodeId);
            }
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString((String)"SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }

    private String getProductName(ExecutionNode node) throws RemoteException {
        String testContainerId = this.getExecutionNodePropertyValue(node, "PROP_TESTCONTAINER");
        String productId = this.planningService.getProperty(this.sessionId, testContainerId, "_node_properties_ProductID_pk_fk").getValue();
        String productName = this.adminService.getProductNameById(this.sessionId, Integer.valueOf(productId).intValue());
        return productName;
    }

    private String getExecutionNodePropertyValue(ExecutionNode node, String propertyName) throws RemoteException {
        PropertyValue[] propertyValues;
        for (PropertyValue propertyValue : propertyValues = node.getPropertyValues()) {
            if (!propertyName.equals(propertyValue.getName())) continue;
            return propertyValue.getValue();
        }
        return null;
    }

    public boolean buildNumberExists(int buildNumber, int nodeId) throws SCTMException {
        try {
            ExecutionNode node = this.execService.getNode(this.sessionId, nodeId);
            if (node == null) {
                throw new SCTMException(MessageFormat.format("Execution definition ''{0}'' does not exist. Check the build configuration.", nodeId));
            }
            String version = this.getExecutionNodePropertyValue(node, "PROP_VERSIONNAME");
            String productName = this.getProductName(node);
            String[] builds = this.adminService.getBuilds(this.sessionId, productName, version);
            String value = String.valueOf(buildNumber);
            for (String build : builds) {
                if (!value.equals(build)) continue;
                return true;
            }
            return false;
        }
        catch (RemoteException e) {
            if (this.handleLostSessionException(e)) {
                return this.buildNumberExists(buildNumber, nodeId);
            }
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new SCTMException(MessageFormat.format(Messages.getString((String)"SCTMService.err.commonFatalError"), e.getMessage()));
        }
    }
}

