/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.plugins.starteam.StarTeamConnection;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StarTeamCheckoutActor
implements FilePath.FileCallable<Boolean> {
    private final Date buildDate;
    private final File changelog;
    private final BuildListener listener;
    private final StarTeamConnection connection;

    public StarTeamCheckoutActor(String hostname, int port, String user, String passwd, String projectname, String viewname, String foldername, Date buildDate, File changelogFile, BuildListener listener) {
        this.connection = new StarTeamConnection(hostname, port, user, passwd, projectname, viewname, foldername);
        this.buildDate = buildDate;
        this.changelog = changelogFile;
        this.listener = listener;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        try {
            this.connection.initialize();
        }
        catch (StarTeamSCMException e) {
            this.listener.getLogger().println(e.getLocalizedMessage());
            return false;
        }
        Collection changed_files = this.connection.findAllFiles(workspace, this.listener.getLogger());
        this.connection.checkOut(changed_files, this.listener.getLogger());
        return true;
    }

    public void dispose() {
        this.connection.close();
    }
}

