/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import com.starbase.starteam.DuplicateServerListEntryException;
import com.starbase.starteam.Folder;
import com.starbase.starteam.LogonException;
import com.starbase.starteam.Project;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerInfo;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.util.OLEDate;
import hudson.plugins.starteam.StarTeamSCMException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarTeamConnection {
    private final ServerInfo serverinfo = new ServerInfo();
    private final String username;
    private final String password;
    private final String projectname;
    private final String viewname;
    private final String foldername;
    private Server server = null;
    private View view = null;
    private Folder rootFolder = null;
    private Project project = null;

    public StarTeamConnection(String hostname, int port, String user, String passwd, String projectname, String viewname, String foldername) {
        String desc_base;
        this.serverinfo.setConnectionType(6);
        String desc = desc_base = "StarTeam connection to " + hostname;
        while (true) {
            int ctr = 1;
            try {
                this.serverinfo.setDescription(desc);
            }
            catch (DuplicateServerListEntryException e) {
                desc = desc_base + " (" + Integer.toString(ctr++) + ")";
                continue;
            }
            break;
        }
        this.serverinfo.setHost(hostname);
        this.serverinfo.setPort(port);
        this.username = user;
        this.password = passwd;
        this.projectname = projectname;
        this.viewname = viewname;
        this.foldername = foldername;
    }

    public void initialize() throws StarTeamSCMException {
        this.server = new Server(this.serverinfo);
        this.server.connect();
        try {
            this.server.logOn(this.username, this.password);
        }
        catch (LogonException e) {
            throw new StarTeamSCMException("Could not log on: " + e.getErrorMessage());
        }
        this.project = StarTeamConnection.findProjectOnServer(this.server, this.projectname);
        this.view = StarTeamConnection.findViewInProject(this.project, this.viewname);
        this.rootFolder = this.findFolderInView(this.view, this.foldername);
        PropertyNames pnames = this.rootFolder.getPropertyNames();
        String[] stringArray = new String[7];
        pnames.getClass();
        stringArray[0] = "LocalFileExists";
        pnames.getClass();
        stringArray[1] = "LocalTimeStamp";
        pnames.getClass();
        stringArray[2] = "Name";
        pnames.getClass();
        stringArray[3] = "Modified";
        pnames.getClass();
        stringArray[4] = "ModifiedTime";
        pnames.getClass();
        stringArray[5] = "ModifiedUserID";
        pnames.getClass();
        stringArray[6] = "Status";
        String[] propsToCache = stringArray;
        this.server.getTypeNames().getClass();
        this.rootFolder.populateNow("File", propsToCache, -1);
    }

    public void checkOut(Collection<com.starbase.starteam.File> filesToCheckOut, PrintStream logger) throws IOException {
        logger.println("*** Performing checkout");
        block4: for (com.starbase.starteam.File f : filesToCheckOut) {
            switch (f.getStatus()) {
                case 1: 
                case 3: 
                case 6: {
                    new File(f.getFullName()).delete();
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                default: {
                    continue block4;
                }
            }
            logger.print("[co] " + f.getFullName() + "... ");
            f.checkout(0, false, true, true);
            f.discard();
            logger.println("ok");
        }
        logger.println("*** done");
    }

    static Project findProjectOnServer(Server server, String projectname) throws StarTeamSCMException {
        for (Project project : server.getProjects()) {
            if (!project.getName().equals(projectname)) continue;
            return project;
        }
        throw new StarTeamSCMException("Couldn't find project " + projectname + " on server " + server.getAddress());
    }

    static View findViewInProject(Project project, String viewname) throws StarTeamSCMException {
        for (View view : project.getAccessibleViews()) {
            if (!view.getName().equals(viewname)) continue;
            return view;
        }
        throw new StarTeamSCMException("Couldn't find view " + viewname + " in project " + project.getName());
    }

    private Map<String, com.starbase.starteam.File> listAllFiles(Folder folder, PrintStream logger) {
        logger.println("*** Looking for versioned files in " + folder.getName());
        HashMap<String, com.starbase.starteam.File> files = new HashMap<String, com.starbase.starteam.File>();
        File workdir = new File(folder.getPath());
        if (!workdir.exists()) {
            logger.println("*** Creating working directory: " + workdir.getAbsolutePath());
            workdir.mkdirs();
        }
        for (Folder folder2 : folder.getSubFolders()) {
            files.putAll(this.listAllFiles(folder2, logger));
        }
        folder.getView().getProject().getServer().getTypeNames().getClass();
        for (Folder folder3 : folder.getItems("File")) {
            com.starbase.starteam.File f = (com.starbase.starteam.File)folder3;
            try {
                files.put(f.getParentFolderHierarchy() + f.getName(), f);
            }
            catch (RuntimeException e) {
                logger.println("Exception in listAllFiles: " + e.getLocalizedMessage());
            }
        }
        folder.discard();
        return files;
    }

    private Collection<com.starbase.starteam.File> getFileSetDifferences(Map<String, com.starbase.starteam.File> thenFiles, Map<String, com.starbase.starteam.File> nowFiles, PrintStream logger) {
        ArrayList<com.starbase.starteam.File> files = new ArrayList<com.starbase.starteam.File>();
        for (Map.Entry<String, com.starbase.starteam.File> e : nowFiles.entrySet()) {
            com.starbase.starteam.File nowFile = e.getValue();
            if (thenFiles.containsKey(e.getKey())) {
                com.starbase.starteam.File thenFile = thenFiles.get(e.getKey());
                if (thenFile.getRevisionNumber() < nowFile.getRevisionNumber()) {
                    logger.println("[modified] " + nowFile.getFullName());
                    files.add(nowFile);
                } else if (!nowFile.getLocalFileExists()) {
                    logger.println("[local missing] " + nowFile.getFullName());
                    files.add(nowFile);
                } else {
                    logger.println("[hit] " + nowFile.getFullName());
                    nowFile.discard();
                }
                thenFile.discard();
                thenFiles.remove(e.getKey());
                continue;
            }
            logger.println("[new] " + nowFile.getFullName());
            files.add(nowFile);
        }
        for (Map.Entry<String, com.starbase.starteam.File> e : thenFiles.entrySet()) {
            logger.println("[deleted] " + e.getValue().getFullName());
            files.add(e.getValue());
        }
        return files;
    }

    private Folder findFolderInView(View view, String foldername) throws StarTeamSCMException {
        if (view.getName().equals(foldername)) {
            return view.getRootFolder();
        }
        File thefolder = new File(foldername);
        Folder result = this.findFolderRecursively(view.getRootFolder(), thefolder);
        if (result == null) {
            throw new StarTeamSCMException("Couldn't find folder " + foldername + " in view " + view.getName());
        }
        return result;
    }

    private Folder findFolderRecursively(Folder folder, File thefolder) {
        ArrayList<Folder> checkLater = new ArrayList<Folder>();
        for (Folder f : folder.getSubFolders()) {
            if (f.getFolderHierarchy().equals(thefolder.getPath() + File.separator)) {
                return f;
            }
            checkLater.add(f);
        }
        for (Folder f : checkLater) {
            Folder result = this.findFolderRecursively(f, thefolder);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Collection<com.starbase.starteam.File> findAllFiles(File workspace, PrintStream logger) {
        logger.println("*** Get list of all files for " + workspace);
        this.rootFolder.setAlternatePathFragment(workspace.getAbsolutePath());
        Map<String, com.starbase.starteam.File> nowFiles = this.listAllFiles(this.rootFolder, logger);
        logger.println("*** done");
        return nowFiles.values();
    }

    public Collection<com.starbase.starteam.File> findChangedFiles(File workspace, PrintStream logger, Date fromDate) {
        logger.println("*** Looking for changed files since " + fromDate);
        this.rootFolder.setAlternatePathFragment(workspace.getAbsolutePath());
        OLEDate oleSince = new OLEDate(fromDate);
        View sinceView = new View(this.view, ViewConfiguration.createFromTime((OLEDate)oleSince));
        Collection<com.starbase.starteam.File> changedFiles = null;
        logger.println("Fetching current files:");
        Map<String, com.starbase.starteam.File> nowFiles = this.listAllFiles(this.rootFolder, logger);
        logger.println("done");
        Folder sinceFolder = null;
        Map<String, com.starbase.starteam.File> sinceFiles = null;
        try {
            sinceFolder = this.findFolderInView(sinceView, this.foldername);
            sinceFolder.setAlternatePathFragment(workspace.getAbsolutePath());
            logger.println("Fetching files at " + fromDate);
            sinceFiles = this.listAllFiles(sinceFolder, logger);
            logger.println("done");
            logger.println("Comparing");
            changedFiles = this.getFileSetDifferences(sinceFiles, nowFiles, logger);
            logger.println("done");
        }
        catch (StarTeamSCMException e) {
            logger.println("Caught exception: " + e.getLocalizedMessage());
            changedFiles = nowFiles.values();
        }
        logger.println("*** done");
        return changedFiles;
    }

    public void close() {
        this.rootFolder.getTypeNames().getClass();
        this.rootFolder.discardItems("File", -1);
        this.view.discard();
        this.project.discard();
        this.server.disconnect();
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

