/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.starteam.StarTeamConnection;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarTeamPollingActor
implements FilePath.FileCallable<Boolean> {
    private final StarTeamConnection connection;
    private final TaskListener listener;
    private final Date sinceDate;

    public StarTeamPollingActor(String hostname, int port, String user, String passwd, String projectname, String viewname, String foldername, Date sinceDate, TaskListener listener) {
        this.connection = new StarTeamConnection(hostname, port, user, passwd, projectname, viewname, foldername);
        this.listener = listener;
        this.sinceDate = sinceDate;
    }

    public Boolean invoke(File f, VirtualChannel channel) throws IOException {
        try {
            this.connection.initialize();
        }
        catch (StarTeamSCMException e) {
            this.listener.getLogger().println(e.getLocalizedMessage());
            this.connection.close();
            return false;
        }
        if (this.connection.findChangedFiles(f, this.listener.getLogger(), this.sinceDate).isEmpty()) {
            return false;
        }
        return true;
    }

    public void dispose() {
        this.connection.close();
    }
}

