/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.starteam.StarTeamConnection;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarTeamPollingActor
implements FilePath.FileCallable<Boolean> {
    private String hostname;
    private int port;
    private String user;
    private String passwd;
    private String projectname;
    private String viewname;
    private String foldername;
    private final TaskListener listener;
    private final Date sinceDate;

    public StarTeamPollingActor(String hostname, int port, String user, String passwd, String projectname, String viewname, String foldername, Date sinceDate, TaskListener listener) {
        this.hostname = hostname;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
        this.projectname = projectname;
        this.viewname = viewname;
        this.foldername = foldername;
        this.listener = listener;
        this.sinceDate = sinceDate;
    }

    public Boolean invoke(File f, VirtualChannel channel) throws IOException {
        StarTeamConnection connection = new StarTeamConnection(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername);
        try {
            connection.initialize();
        }
        catch (StarTeamSCMException e) {
            this.listener.getLogger().println(e.getLocalizedMessage());
            connection.close();
            return false;
        }
        if (connection.findChangedFiles(f, this.listener.getLogger(), this.sinceDate).isEmpty()) {
            connection.close();
            return false;
        }
        connection.close();
        return true;
    }
}

