/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.plugins.starteam.StarTeamConnection;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StarTeamCheckoutActor
implements FilePath.FileCallable<Boolean> {
    private final Date buildDate;
    private final File changelog;
    private final BuildListener listener;
    private String hostname;
    private int port;
    private String user;
    private String passwd;
    private String projectname;
    private String viewname;
    private String foldername;

    public StarTeamCheckoutActor(String hostname, int port, String user, String passwd, String projectname, String viewname, String foldername, Date buildDate, File changelogFile, BuildListener listener) {
        this.hostname = hostname;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
        this.projectname = projectname;
        this.viewname = viewname;
        this.foldername = foldername;
        this.buildDate = buildDate;
        this.changelog = changelogFile;
        this.listener = listener;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        StarTeamConnection connection = new StarTeamConnection(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername);
        try {
            connection.initialize();
        }
        catch (StarTeamSCMException e) {
            this.listener.getLogger().println(e.getLocalizedMessage());
            return false;
        }
        Collection changedFiles = connection.findAllFiles(workspace, this.listener.getLogger());
        connection.checkOut(changedFiles, this.listener.getLogger());
        connection.close();
        return true;
    }
}

