/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import com.starbase.starteam.File;
import hudson.Util;
import hudson.plugins.starteam.StarTeamConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StarTeamChangeLogBuilder {
    public static boolean writeChangeLog(OutputStream aOutputStream, Collection<File> aChanges, StarTeamConnection aConnection) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(aOutputStream, Charset.forName("UTF-8"));
        PrintWriter printwriter = new PrintWriter(writer);
        printwriter.println("<?xml version='1.0' encoding='UTF-8'?>");
        printwriter.println("<changelog>");
        for (File change : aChanges) {
            printwriter.println("\t<entry>");
            printwriter.println("\t\t<fileName>" + change.getName() + "</fileName>");
            printwriter.println("\t\t<revisionNumber>" + change.getContentVersion() + "</revisionNumber>");
            printwriter.println("\t\t<date>" + Util.xmlEscape((String)StarTeamChangeLogBuilder.javaDateToStringDate(change.getModifiedTime().createDate())) + "</date>");
            printwriter.println("\t\t<message>" + Util.xmlEscape((String)change.getComment()) + "</message>");
            printwriter.println("\t\t<user>" + aConnection.getUsername(change.getModifiedBy()) + "</user>");
            printwriter.println("\t</entry>");
        }
        printwriter.println("</changelog>");
        printwriter.close();
        return true;
    }

    public static String javaDateToStringDate(Date aDate) {
        if (aDate == null) {
            return "";
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.clear();
        cal.setTime(aDate);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String date = year + "-" + StarTeamChangeLogBuilder.putZero(month) + "-" + StarTeamChangeLogBuilder.putZero(day);
        if (hour + min + sec > 0) {
            date = date + " " + StarTeamChangeLogBuilder.putZero(hour) + ":" + StarTeamChangeLogBuilder.putZero(min) + ":" + StarTeamChangeLogBuilder.putZero(sec);
        }
        return date;
    }

    private static String putZero(int aIndex) {
        if (aIndex < 10) {
            return "0" + aIndex;
        }
        return aIndex + "";
    }
}

