/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.starteam.StarTeamChangeLogParser;
import hudson.plugins.starteam.StarTeamCheckoutActor;
import hudson.plugins.starteam.StarTeamPollingActor;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class StarTeamSCM
extends SCM {
    @Extension
    public static final StarTeamSCMDescriptorImpl DESCRIPTOR = new StarTeamSCMDescriptorImpl();
    private final String user;
    private final String passwd;
    private final String projectname;
    private final String viewname;
    private final String foldername;
    private final String hostname;
    private final int port;

    @DataBoundConstructor
    public StarTeamSCM(String hostname, int port, String projectname, String viewname, String foldername, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.projectname = projectname;
        this.viewname = viewname;
        this.foldername = foldername;
        this.user = username;
        this.passwd = password;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        FilePath changeLogFilePath;
        Date currentBuildDate;
        StarTeamCheckoutActor co_actor;
        boolean status = false;
        Date previousBuildDate = null;
        if (build.getPreviousBuild() != null) {
            previousBuildDate = build.getPreviousBuild().getTimestamp().getTime();
        }
        if (((Boolean)workspace.act((FilePath.FileCallable)(co_actor = new StarTeamCheckoutActor(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername, previousBuildDate, currentBuildDate = build.getTimestamp().getTime(), changeLogFilePath = new FilePath(changelogFile), listener)))).booleanValue()) {
            status = true;
        } else {
            listener.getLogger().println("StarTeam checkout failed");
            status = false;
        }
        return status;
    }

    public ChangeLogParser createChangeLogParser() {
        return new StarTeamChangeLogParser();
    }

    public StarTeamSCMDescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean pollChanges(AbstractProject proj, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        Date currentServerDate;
        StarTeamPollingActor p_actor;
        boolean status = false;
        Run run = proj.getLastBuild();
        Date sinceDate = null;
        if (run != null) {
            sinceDate = run.getTimestamp().getTime();
        }
        if (((Boolean)workspace.act((FilePath.FileCallable)(p_actor = new StarTeamPollingActor(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername, sinceDate, currentServerDate = new Date(), listener)))).booleanValue()) {
            status = true;
        } else {
            listener.getLogger().println("StarTeam polling failed");
        }
        return status;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getProjectname() {
        return this.projectname;
    }

    public String getViewname() {
        return this.viewname;
    }

    public String getFoldername() {
        return this.foldername;
    }

    public String getUsername() {
        return this.user;
    }

    public String getPassword() {
        return this.passwd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StarTeamSCMDescriptorImpl
    extends SCMDescriptor<StarTeamSCM> {
        private final Collection<StarTeamSCM> scms = new ArrayList<StarTeamSCM>();

        public StarTeamSCMDescriptorImpl() {
            super(StarTeamSCM.class, null);
            this.load();
        }

        public String getDisplayName() {
            return "StarTeam";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            StarTeamSCM scm = null;
            try {
                scm = (StarTeamSCM)((Object)req.bindParameters(StarTeamSCM.class, "starteam."));
                this.scms.add(scm);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            return scm;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return true;
        }
    }
}

