/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.plugins.starteam.StarTeamChangeLogBuilder;
import hudson.plugins.starteam.StarTeamConnection;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.plugins.starteam.StarTeamViewSelector;
import hudson.remoting.VirtualChannel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StarTeamCheckoutActor
implements FilePath.FileCallable<Boolean> {
    private static final long serialVersionUID = -3748818546244161292L;
    private final Date previousBuildDate;
    private final Date currentBuilddDate;
    private final FilePath changelog;
    private final BuildListener listener;
    private final String hostname;
    private final int port;
    private final String user;
    private final String passwd;
    private final String projectname;
    private final String viewname;
    private final String foldername;
    private final StarTeamViewSelector config;

    public StarTeamCheckoutActor(String hostname, int port, String user, String passwd, String projectname, String viewname, String foldername, StarTeamViewSelector config, Date previousBuildDate, Date currentBuildDate, FilePath changelogFile, BuildListener listener) {
        this.hostname = hostname;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
        this.projectname = projectname;
        this.viewname = viewname;
        this.foldername = foldername;
        this.previousBuildDate = previousBuildDate;
        this.currentBuilddDate = currentBuildDate;
        this.changelog = changelogFile;
        this.listener = listener;
        this.config = config;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException {
        StarTeamConnection connection = new StarTeamConnection(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername, this.config);
        try {
            connection.initialize();
        }
        catch (StarTeamSCMException e) {
            this.listener.getLogger().println(e.getLocalizedMessage());
            return false;
        }
        boolean clearNoStarteamFiles = true;
        Map nowFiles = connection.findAllFiles(workspace, this.listener.getLogger(), clearNoStarteamFiles);
        this.listener.getLogger().println("performing checkout ...");
        connection.checkOut(nowFiles.values(), this.listener.getLogger());
        this.listener.getLogger().println("creating change log file ");
        try {
            this.createChangeLog(nowFiles, workspace, this.changelog, this.listener, this.previousBuildDate, connection);
        }
        catch (InterruptedException e) {
            this.listener.getLogger().println("unable to create changelog file " + e.getMessage());
        }
        connection.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createChangeLog(Map<String, com.starbase.starteam.File> aNowFiles, File aRootFile, FilePath aChangelogFile, BuildListener aListener, Date aLastBuildDate, StarTeamConnection aConnection) throws IOException, InterruptedException {
        if (aLastBuildDate == null) {
            this.listener.getLogger().println("last build date is null, creating an empty change log file");
            this.createEmptyChangeLog(aChangelogFile, aListener, "log");
            return true;
        }
        BufferedOutputStream os = new BufferedOutputStream(aChangelogFile.write());
        Date synchronizedStarteamPreviousBuildDate = aConnection.calculatePreviousDateWithTimeZoneCheck(aLastBuildDate, this.currentBuilddDate);
        boolean created = false;
        Collection changes = null;
        try {
            this.listener.getLogger().println("searching for changed file since " + aLastBuildDate);
            changes = aConnection.findChangedFiles(aNowFiles, aRootFile, this.listener.getLogger(), synchronizedStarteamPreviousBuildDate);
            created = StarTeamChangeLogBuilder.writeChangeLog((OutputStream)os, (Collection)changes, (StarTeamConnection)aConnection);
        }
        catch (Exception ex) {
            this.listener.getLogger().println("change log creation failed due to unexpected error : " + ex.getMessage());
        }
        finally {
            ((OutputStream)os).close();
        }
        if (!created) {
            this.createEmptyChangeLog(aChangelogFile, aListener, "log");
        }
        return true;
    }

    protected final boolean createEmptyChangeLog(FilePath aChangelogFile, BuildListener aListener, String aRootTag) throws InterruptedException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(aChangelogFile.write(), Charset.forName("UTF-8"));
            PrintWriter printwriter = new PrintWriter(writer);
            printwriter.write("<" + aRootTag + "/>");
            printwriter.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace(aListener.error(e.getMessage()));
            return false;
        }
    }
}

