/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import com.starbase.starteam.DuplicateServerListEntryException;
import com.starbase.starteam.Folder;
import com.starbase.starteam.LogonException;
import com.starbase.starteam.Project;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerAdministration;
import com.starbase.starteam.ServerInfo;
import com.starbase.starteam.User;
import com.starbase.starteam.UserAccount;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.util.OLEDate;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.plugins.starteam.StarTeamViewSelector;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class StarTeamConnection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String hostName;
    private final int port;
    private final String userName;
    private final String password;
    private final String projectName;
    private final String viewName;
    private final String folderName;
    private final StarTeamViewSelector configSelector;
    private transient Server server;
    private transient View view;
    private transient Folder rootFolder;
    private transient Project project;
    private transient ServerAdministration srvAdmin;

    public StarTeamConnection(String hostName, int port, String userName, String password, String projectName, String viewName, String folderName, StarTeamViewSelector configSelector) {
        this.checkParameters(hostName, port, userName, password, projectName, viewName, folderName);
        this.hostName = hostName;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.projectName = projectName;
        this.viewName = viewName;
        this.folderName = folderName;
        this.configSelector = configSelector;
    }

    private ServerInfo createServerInfo() {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setConnectionType(6);
        serverInfo.setHost(this.hostName);
        serverInfo.setPort(this.port);
        this.populateDescription(serverInfo);
        return serverInfo;
    }

    void populateDescription(ServerInfo serverInfo) {
        int counter = 0;
        while (!this.setDescription(serverInfo, counter)) {
            ++counter;
        }
    }

    private boolean setDescription(ServerInfo serverInfo, int counter) {
        try {
            serverInfo.setDescription("StarTeam connection to " + this.hostName + (counter == 0 ? "" : " (" + Integer.toString(counter) + ")"));
            return true;
        }
        catch (DuplicateServerListEntryException e) {
            return false;
        }
    }

    private void checkParameters(String hostName, int port, String userName, String password, String projectName, String viewName, String folderName) {
        if (null == hostName) {
            throw new NullPointerException("hostName cannot be null");
        }
        if (null == userName) {
            throw new NullPointerException("user cannot be null");
        }
        if (null == password) {
            throw new NullPointerException("passwd cannot be null");
        }
        if (null == projectName) {
            throw new NullPointerException("projectName cannot be null");
        }
        if (null == viewName) {
            throw new NullPointerException("viewName cannot be null");
        }
        if (null == folderName) {
            throw new NullPointerException("folderName cannot be null");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
    }

    public void initialize() throws StarTeamSCMException {
        this.server = new Server(this.createServerInfo());
        this.server.connect();
        try {
            this.server.logOn(this.userName, this.password);
        }
        catch (LogonException e) {
            throw new StarTeamSCMException("Could not log on: " + e.getErrorMessage());
        }
        this.project = StarTeamConnection.findProjectOnServer((Server)this.server, (String)this.projectName);
        this.view = StarTeamConnection.findViewInProject((Project)this.project, (String)this.viewName);
        if (this.configSelector != null) {
            try {
                this.view = this.configSelector.configView(this.view);
            }
            catch (ParseException e) {
                throw new StarTeamSCMException("Could not correctly parse configuration date: " + e.getMessage());
            }
        }
        this.rootFolder = this.findFolderInView(this.view, this.folderName);
        PropertyNames pnames = this.rootFolder.getPropertyNames();
        String[] stringArray = new String[7];
        pnames.getClass();
        stringArray[0] = "LocalFileExists";
        pnames.getClass();
        stringArray[1] = "LocalTimeStamp";
        pnames.getClass();
        stringArray[2] = "Name";
        pnames.getClass();
        stringArray[3] = "Modified";
        pnames.getClass();
        stringArray[4] = "ModifiedTime";
        pnames.getClass();
        stringArray[5] = "ModifiedUserID";
        pnames.getClass();
        stringArray[6] = "Status";
        String[] propsToCache = stringArray;
        this.server.getTypeNames().getClass();
        this.rootFolder.populateNow("File", propsToCache, -1);
    }

    public void checkOut(Collection<com.starbase.starteam.File> filesToCheckOut, PrintStream logger) throws IOException {
        logger.println("*** Performing checkout");
        block4: for (com.starbase.starteam.File f : filesToCheckOut) {
            switch (f.getStatus()) {
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    new File(f.getFullName()).delete();
                    logger.println("[co] Deleted File: " + f.getFullName());
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                default: {
                    continue block4;
                }
            }
            logger.print("[co] " + f.getFullName() + "... \n");
            f.checkout(0, true, true, true);
            f.discard();
        }
    }

    public String getUsername(int userId) {
        boolean canReadUserAccts = true;
        User stUser = this.server.getUser(userId);
        String userName = stUser.getName();
        this.srvAdmin = this.server.getAdministration();
        UserAccount[] userAccts = null;
        try {
            userAccts = this.srvAdmin.getUserAccounts();
        }
        catch (Exception e) {
            System.out.println("WARNING: Looks like this user does not have the permission to access UserAccounts on the StarTeam Server!");
            System.out.println("WARNING: Please contact your administrator and ask to be given the permission \"Administer User Accounts\" on the server.");
            System.out.println("WARNING: Defaulting to just using User Full Names which breaks the ability to send email to the individuals who break the build in Hudson!");
            canReadUserAccts = false;
        }
        if (canReadUserAccts) {
            UserAccount ua = userAccts[0];
            for (int i = 0; i < userAccts.length; ++i) {
                ua = userAccts[i];
                if (!ua.getName().equals(userName)) continue;
                System.out.println("INFO: From '" + userName + "' found existing user LogonName = " + ua.getLogOnName() + " with ID '" + ua.getID() + "' and email '" + ua.getEmailAddress() + "'");
                return ua.getLogOnName();
            }
        } else {
            String shortname = this.server.getUser(userId).getName();
            if (shortname.indexOf(",") > 0) {
                shortname = shortname.charAt(shortname.indexOf(" ") + 1) + shortname.substring(0, shortname.indexOf(","));
            } else if (shortname.indexOf(" ") > 0) {
                shortname = shortname.charAt(0) + shortname.substring(shortname.indexOf(" ") + 1, shortname.length());
            }
            return shortname;
        }
        return "unknown";
    }

    public OLEDate getServerTime() {
        return this.server.getCurrentTime();
    }

    static Project findProjectOnServer(Server server, String projectname) throws StarTeamSCMException {
        for (Project project : server.getProjects()) {
            if (!project.getName().equals(projectname)) continue;
            return project;
        }
        throw new StarTeamSCMException("Couldn't find project " + projectname + " on server " + server.getAddress());
    }

    static View findViewInProject(Project project, String viewname) throws StarTeamSCMException {
        for (View view : project.getAccessibleViews()) {
            if (!view.getName().equals(viewname)) continue;
            return view;
        }
        throw new StarTeamSCMException("Couldn't find view " + viewname + " in project " + project.getName());
    }

    private Map<String, com.starbase.starteam.File> listAllFiles(Folder folder, PrintStream logger, boolean clearNoStarteamFiles) {
        boolean success;
        HashMap<String, com.starbase.starteam.File> files = new HashMap<String, com.starbase.starteam.File>();
        File workdir = new File(folder.getPath());
        if (!workdir.exists() && !(success = workdir.mkdirs())) {
            logger.println("*** Creation of working directory failed : " + workdir.getAbsolutePath());
        }
        ArrayList<String> starteamFilesInDirectory = new ArrayList<String>();
        for (Folder folder2 : folder.getSubFolders()) {
            starteamFilesInDirectory.add(folder2.getName());
            files.putAll(this.listAllFiles(folder2, logger, clearNoStarteamFiles));
        }
        folder.getView().getProject().getServer().getTypeNames().getClass();
        for (Folder folder3 : folder.getItems("File")) {
            com.starbase.starteam.File f = (com.starbase.starteam.File)folder3;
            try {
                files.put(f.getParentFolderHierarchy() + f.getName(), f);
                starteamFilesInDirectory.add(f.getName());
            }
            catch (RuntimeException e) {
                logger.println("Exception in listAllFiles: " + e.getLocalizedMessage());
            }
        }
        if (clearNoStarteamFiles) {
            this.clearCurrentDirectoryOfNonStarteamFiles(starteamFilesInDirectory, workdir);
        }
        folder.discard();
        return files;
    }

    private void clearCurrentDirectoryOfNonStarteamFiles(List<String> starteamFiles, File workingDirectory) {
        File[] filesInFolder;
        if (starteamFiles == null || workingDirectory == null || !workingDirectory.isDirectory()) {
            return;
        }
        for (File currentFile : filesInFolder = workingDirectory.listFiles()) {
            if (starteamFiles.contains(currentFile.getName())) continue;
            this.deleteFileOrDirectory(currentFile);
        }
    }

    private void deleteFileOrDirectory(File aFileOrDirectory) {
        if (aFileOrDirectory.isDirectory()) {
            File[] childrens;
            for (File currentFile : childrens = aFileOrDirectory.listFiles()) {
                this.deleteFileOrDirectory(currentFile);
            }
        }
        aFileOrDirectory.delete();
    }

    private Collection<com.starbase.starteam.File> getFileSetDifferences(Map<String, com.starbase.starteam.File> thenFiles, Map<String, com.starbase.starteam.File> nowFiles, PrintStream logger) {
        ArrayList<com.starbase.starteam.File> files = new ArrayList<com.starbase.starteam.File>();
        for (Map.Entry<String, com.starbase.starteam.File> e : nowFiles.entrySet()) {
            com.starbase.starteam.File nowFile = e.getValue();
            if (thenFiles.containsKey(e.getKey())) {
                com.starbase.starteam.File thenFile = thenFiles.get(e.getKey());
                if (thenFile.getRevisionNumber() < nowFile.getRevisionNumber()) {
                    logger.println("[modified] " + nowFile.getFullName());
                    files.add(nowFile);
                } else if (!nowFile.getLocalFileExists()) {
                    logger.println("[local missing] " + nowFile.getFullName());
                    files.add(nowFile);
                } else {
                    nowFile.discard();
                }
                thenFile.discard();
                thenFiles.remove(e.getKey());
                continue;
            }
            logger.println("[new] " + nowFile.getFullName());
            files.add(nowFile);
        }
        for (Map.Entry<String, com.starbase.starteam.File> e : thenFiles.entrySet()) {
            logger.println("[deleted] " + e.getValue().getFullName());
            files.add(e.getValue());
        }
        return files;
    }

    private Folder findFolderInView(View view, String foldername) throws StarTeamSCMException {
        if (view.getName().equals(foldername)) {
            return view.getRootFolder();
        }
        File thefolder = new File(foldername);
        Folder result = this.findFolderRecursively(view.getRootFolder(), thefolder);
        if (result == null) {
            throw new StarTeamSCMException("Couldn't find folder " + foldername + " in view " + view.getName());
        }
        return result;
    }

    private Folder findFolderRecursively(Folder folder, File thefolder) {
        ArrayList<Folder> checkLater = new ArrayList<Folder>();
        for (Folder f : folder.getSubFolders()) {
            if (f.getFolderHierarchy().equals(thefolder.getPath() + File.separator)) {
                return f;
            }
            checkLater.add(f);
        }
        for (Folder f : checkLater) {
            Folder result = this.findFolderRecursively(f, thefolder);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Map<String, com.starbase.starteam.File> findAllFiles(File workspace, PrintStream logger, boolean clearNoStarteamFiles) {
        logger.println("*** Get list of all files for " + workspace);
        this.rootFolder.setAlternatePathFragment(workspace.getAbsolutePath());
        Map nowFiles = this.listAllFiles(this.rootFolder, logger, clearNoStarteamFiles);
        logger.println("*** done");
        return nowFiles;
    }

    public Collection<com.starbase.starteam.File> findChangedFiles(File workspace, PrintStream logger, Date fromDate) {
        boolean clearNoStarteamFiles = false;
        this.rootFolder.setAlternatePathFragment(workspace.getAbsolutePath());
        logger.println("Fetching current files:");
        Map nowFiles = this.listAllFiles(this.rootFolder, logger, clearNoStarteamFiles);
        return this.findChangedFiles(nowFiles, workspace, logger, fromDate);
    }

    public Collection<com.starbase.starteam.File> findChangedFiles(Map<String, com.starbase.starteam.File> nowFiles, File workspace, PrintStream logger, Date fromDate) {
        boolean clearNoStarteamFiles = false;
        logger.println("*** Looking for changed files since " + fromDate);
        this.rootFolder.setAlternatePathFragment(workspace.getAbsolutePath());
        OLEDate oleSince = new OLEDate(fromDate);
        View sinceView = new View(this.view, ViewConfiguration.createFromTime((OLEDate)oleSince));
        Collection changedFiles = null;
        Folder sinceFolder = null;
        Map sinceFiles = null;
        try {
            sinceFolder = this.findFolderInView(sinceView, this.folderName);
            sinceFolder.setAlternatePathFragment(workspace.getAbsolutePath());
            logger.println("Fetching files at " + fromDate);
            sinceFiles = this.listAllFiles(sinceFolder, logger, clearNoStarteamFiles);
            logger.println("done");
            logger.println("Comparing");
            changedFiles = this.getFileSetDifferences(sinceFiles, nowFiles, logger);
            logger.println("done");
        }
        catch (StarTeamSCMException e) {
            logger.println("Caught exception: " + e.getLocalizedMessage());
            changedFiles = nowFiles.values();
        }
        logger.println("*** done");
        return changedFiles;
    }

    public Date calculatePreviousDateWithTimeZoneCheck(Date aPreviousBuildDate, Date aCurrentBuildDate) {
        OLEDate starteamServerTime = this.getServerTime();
        long starteamDateLongValue = starteamServerTime.getLongValue();
        long buildServerDateLongValue = aCurrentBuildDate.getTime();
        long timeDiff = starteamDateLongValue - buildServerDateLongValue;
        long lastBuildDateLongValue = aPreviousBuildDate.getTime();
        long lastStarteamDateLongValue = timeDiff + lastBuildDateLongValue;
        Date synchLastBuildDate = new Date(lastStarteamDateLongValue);
        return synchLastBuildDate;
    }

    public void close() {
        if (this.server.isConnected()) {
            if (this.rootFolder != null) {
                this.rootFolder.getTypeNames().getClass();
                this.rootFolder.discardItems("File", -1);
            }
            this.view.discard();
            this.project.discard();
            this.server.disconnect();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        StarTeamConnection other = (StarTeamConnection)object;
        return this.port == other.port && this.hostName.equals(other.hostName) && this.userName.equals(other.userName) && this.password.equals(other.password) && this.projectName.equals(other.projectName) && this.viewName.equals(other.viewName) && this.folderName.equals(other.folderName);
    }

    public int hashCode() {
        return this.userName.hashCode();
    }

    public String toString() {
        return "host: " + this.hostName + ", port: " + Integer.toString(this.port) + ", user: " + this.userName + ", passwd: ******, project: " + this.projectName + ", view: " + this.viewName + ", folder: " + this.folderName;
    }
}

