/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import com.starbase.starteam.Label;
import com.starbase.starteam.PromotionState;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.util.OLEDate;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.plugins.starteam.StarTeamViewSelector;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class StarTeamViewSelector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String configInfo;
    private final ConfigType configType;
    private final DateFormat df;

    public StarTeamViewSelector(String configInfo, String configType) throws ParseException {
        this.configInfo = configInfo;
        ConfigType result = ConfigType.CURRENT;
        if (configType != null) {
            try {
                result = ConfigType.valueOf((String)configType.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
        this.configType = result;
        this.df = new SimpleDateFormat("yyyy/M/d");
        if (this.configType == ConfigType.TIME) {
            this.df.parse(configInfo);
        }
    }

    public View configView(View baseView) throws StarTeamSCMException, ParseException {
        ViewConfiguration configuration;
        if (this.configInfo != null && !this.configInfo.isEmpty()) {
            switch (1.$SwitchMap$hudson$plugins$starteam$StarTeamViewSelector$ConfigType[this.configType.ordinal()]) {
                case 1: {
                    configuration = ViewConfiguration.createTip();
                    break;
                }
                case 2: {
                    int labelId = StarTeamViewSelector.findLabelInView((View)baseView, (String)this.configInfo);
                    configuration = ViewConfiguration.createFromLabel((int)labelId);
                    break;
                }
                case 3: {
                    Integer promotionStateId = StarTeamViewSelector.findPromotionStateInView((View)baseView, (String)this.configInfo);
                    if (promotionStateId != null) {
                        configuration = ViewConfiguration.createFromPromotionState((int)promotionStateId);
                        break;
                    }
                    configuration = ViewConfiguration.createTip();
                    break;
                }
                case 4: {
                    Date effectiveDate = this.df.parse(this.configInfo);
                    configuration = ViewConfiguration.createFromTime((OLEDate)new OLEDate(effectiveDate));
                    break;
                }
                default: {
                    throw new StarTeamSCMException("Could not construct view - no configuration provided");
                }
            }
        } else {
            configuration = ViewConfiguration.createTip();
        }
        return new View(baseView, configuration);
    }

    private static int findLabelInView(View view, String labelname) throws StarTeamSCMException {
        for (Label label : view.getLabels()) {
            if (!labelname.equals(label.getName())) continue;
            return label.getID();
        }
        throw new StarTeamSCMException("Couldn't find label [" + labelname + "] in view " + view.getName());
    }

    private static Integer findPromotionStateInView(View view, String promotionState) throws StarTeamSCMException {
        for (PromotionState ps : view.getPromotionModel().getPromotionStates()) {
            if (!promotionState.equals(ps.getName())) continue;
            if (ps.getLabelID() == -1) {
                return null;
            }
            return ps.getObjectID();
        }
        throw new StarTeamSCMException("Couldn't find promotion state " + promotionState + " in view " + view.getName());
    }

    public String getConfigInfo() {
        return this.configInfo;
    }

    public String getConfigType() {
        return this.configType.name();
    }
}

