/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import com.starbase.starteam.DuplicateServerListEntryException;
import com.starbase.starteam.Folder;
import com.starbase.starteam.LogonException;
import com.starbase.starteam.Project;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerAdministration;
import com.starbase.starteam.ServerInfo;
import com.starbase.starteam.User;
import com.starbase.starteam.UserAccount;
import com.starbase.starteam.View;
import com.starbase.util.OLEDate;
import hudson.plugins.starteam.StarTeamChangeLogEntry;
import hudson.plugins.starteam.StarTeamChangeSet;
import hudson.plugins.starteam.StarTeamFilePoint;
import hudson.plugins.starteam.StarTeamFilePointFunctions;
import hudson.plugins.starteam.StarTeamFunctions;
import hudson.plugins.starteam.StarTeamSCMException;
import hudson.plugins.starteam.StarTeamViewSelector;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.exception.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class StarTeamConnection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FILE_POINT_FILENAME = "starteam-filepoints.csv";
    private final String hostName;
    private final int port;
    private final String userName;
    private final String password;
    private final String projectName;
    private final String viewName;
    private final String folderName;
    private final StarTeamViewSelector configSelector;
    private transient Server server;
    private transient View view;
    private transient Folder rootFolder;
    private transient Project project;
    private transient ServerAdministration srvAdmin;

    public StarTeamConnection(String hostName, int port, String userName, String password, String projectName, String viewName, String folderName, StarTeamViewSelector configSelector) {
        this.checkParameters(hostName, port, userName, password, projectName, viewName, folderName);
        this.hostName = hostName;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.projectName = projectName;
        this.viewName = viewName;
        this.folderName = folderName;
        this.configSelector = configSelector;
    }

    public StarTeamConnection(StarTeamConnection oldConnection, StarTeamViewSelector configSelector) {
        this(oldConnection.hostName, oldConnection.port, oldConnection.userName, oldConnection.password, oldConnection.projectName, oldConnection.viewName, oldConnection.folderName, configSelector);
    }

    private ServerInfo createServerInfo() {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setConnectionType(6);
        serverInfo.setHost(this.hostName);
        serverInfo.setPort(this.port);
        this.populateDescription(serverInfo);
        return serverInfo;
    }

    void populateDescription(ServerInfo serverInfo) {
        int counter = 0;
        while (!this.setDescription(serverInfo, counter)) {
            ++counter;
        }
    }

    private boolean setDescription(ServerInfo serverInfo, int counter) {
        try {
            serverInfo.setDescription("StarTeam connection to " + this.hostName + (counter == 0 ? "" : " (" + Integer.toString(counter) + ")"));
            return true;
        }
        catch (DuplicateServerListEntryException e) {
            return false;
        }
    }

    private void checkParameters(String hostName, int port, String userName, String password, String projectName, String viewName, String folderName) {
        if (null == hostName) {
            throw new NullPointerException("hostName cannot be null");
        }
        if (null == userName) {
            throw new NullPointerException("user cannot be null");
        }
        if (null == password) {
            throw new NullPointerException("passwd cannot be null");
        }
        if (null == projectName) {
            throw new NullPointerException("projectName cannot be null");
        }
        if (null == viewName) {
            throw new NullPointerException("viewName cannot be null");
        }
        if (null == folderName) {
            throw new NullPointerException("folderName cannot be null");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
    }

    public void initialize() throws StarTeamSCMException {
        this.server = new Server(this.createServerInfo());
        this.server.connect();
        try {
            this.server.logOn(this.userName, this.password);
        }
        catch (LogonException e) {
            throw new StarTeamSCMException("Could not log on: " + e.getErrorMessage());
        }
        this.project = StarTeamConnection.findProjectOnServer((Server)this.server, (String)this.projectName);
        this.view = StarTeamConnection.findViewInProject((Project)this.project, (String)this.viewName);
        if (this.configSelector != null) {
            View configuredView = null;
            try {
                configuredView = this.configSelector.configView(this.view);
            }
            catch (ParseException e) {
                throw new StarTeamSCMException("Could not correctly parse configuration date: " + e.getMessage());
            }
            if (configuredView != null) {
                this.view = configuredView;
            }
        }
        this.rootFolder = StarTeamFunctions.findFolderInView((View)this.view, (String)this.folderName);
        PropertyNames pnames = this.rootFolder.getPropertyNames();
        String[] stringArray = new String[7];
        pnames.getClass();
        stringArray[0] = "LocalFileExists";
        pnames.getClass();
        stringArray[1] = "LocalTimeStamp";
        pnames.getClass();
        stringArray[2] = "Name";
        pnames.getClass();
        stringArray[3] = "Modified";
        pnames.getClass();
        stringArray[4] = "ModifiedTime";
        pnames.getClass();
        stringArray[5] = "ModifiedUserID";
        pnames.getClass();
        stringArray[6] = "Status";
        String[] propsToCache = stringArray;
        this.server.getTypeNames().getClass();
        this.rootFolder.populateNow("File", propsToCache, -1);
    }

    public void checkOut(StarTeamChangeSet changeSet, PrintStream logger, File buildFolder) throws IOException {
        boolean quietDelete;
        boolean quietCheckout;
        logger.println("*** Performing checkout on [" + changeSet.getFilesToCheckout().size() + "] files");
        boolean bl = quietCheckout = changeSet.getFilesToCheckout().size() >= 2000;
        if (quietCheckout) {
            logger.println("*** More than 2000 files, quiet mode enabled");
        }
        block8: for (com.starbase.starteam.File f : changeSet.getFilesToCheckout()) {
            boolean dirty = true;
            switch (f.getStatus()) {
                case 6: {
                    dirty = false;
                }
                case 1: 
                case 3: 
                case 4: {
                    new File(f.getFullName()).delete();
                    if (quietCheckout) break;
                    logger.println("[co] Deleted File: " + f.getFullName());
                    break;
                }
                case 2: 
                case 5: {
                    dirty = false;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (!quietCheckout) {
                logger.println("[co] " + f.getFullName() + "... attempt");
            }
            try {
                f.checkout(0, true, true, true);
            }
            catch (IOException e) {
                logger.print("[checkout] [exception] [Problem checking out file: " + f.getFullName() + "] \n" + ExceptionUtils.getFullStackTrace((Throwable)e) + "\n");
                throw e;
            }
            catch (RuntimeException e) {
                logger.print("[checkout] [exception] [Problem checking out file: " + f.getFullName() + "] \n" + ExceptionUtils.getFullStackTrace((Throwable)e) + "\n");
                throw e;
            }
            if (dirty) {
                changeSet.getChanges().add(this.FileToStarTeamChangeLogEntry(f, "dirty"));
            }
            f.discard();
            if (quietCheckout) continue;
            logger.println("[co] " + f.getFullName() + "... ok");
        }
        logger.println("*** removing [" + changeSet.getFilesToRemove().size() + "] files");
        boolean bl2 = quietDelete = changeSet.getFilesToRemove().size() > 100;
        if (quietDelete) {
            logger.println("*** More than 100 files, quiet mode enabled");
        }
        for (File f : changeSet.getFilesToRemove()) {
            if (f.exists()) {
                if (!quietDelete) {
                    logger.println("[remove] [" + f + "]");
                }
                f.delete();
                continue;
            }
            logger.println("[remove:warn] Planned to remove [" + f + "]");
        }
        logger.println("*** storing change set");
        StarTeamFilePointFunctions.storeCollection((File)new File(buildFolder, "starteam-filepoints.csv"), (Collection)changeSet.getFilePointsToRemember());
        logger.println("***checkout done");
    }

    public String getUsername(int userId) {
        boolean canReadUserAccts = true;
        User stUser = this.server.getUser(userId);
        String userName = stUser.getName();
        this.srvAdmin = this.server.getAdministration();
        UserAccount[] userAccts = null;
        try {
            userAccts = this.srvAdmin.getUserAccounts();
        }
        catch (Exception e) {
            System.out.println("WARNING: Looks like this user does not have the permission to access UserAccounts on the StarTeam Server!");
            System.out.println("WARNING: Please contact your administrator and ask to be given the permission \"Administer User Accounts\" on the server.");
            System.out.println("WARNING: Defaulting to just using User Full Names which breaks the ability to send email to the individuals who break the build in Hudson!");
            canReadUserAccts = false;
        }
        if (canReadUserAccts) {
            UserAccount ua = userAccts[0];
            for (int i = 0; i < userAccts.length; ++i) {
                ua = userAccts[i];
                if (!ua.getName().equals(userName)) continue;
                System.out.println("INFO: From '" + userName + "' found existing user LogonName = " + ua.getLogOnName() + " with ID '" + ua.getID() + "' and email '" + ua.getEmailAddress() + "'");
                return ua.getLogOnName();
            }
        } else {
            String shortname = this.server.getUser(userId).getName();
            if (shortname.indexOf(",") > 0) {
                shortname = shortname.charAt(shortname.indexOf(" ") + 1) + shortname.substring(0, shortname.indexOf(","));
            } else if (shortname.indexOf(" ") > 0) {
                shortname = shortname.charAt(0) + shortname.substring(shortname.indexOf(" ") + 1, shortname.length());
            }
            return shortname;
        }
        return "unknown";
    }

    public Folder getRootFolder() {
        return this.rootFolder;
    }

    public OLEDate getServerTime() {
        return this.server.getCurrentTime();
    }

    static Project findProjectOnServer(Server server, String projectname) throws StarTeamSCMException {
        for (Project project : server.getProjects()) {
            if (!project.getName().equals(projectname)) continue;
            return project;
        }
        throw new StarTeamSCMException("Couldn't find project " + projectname + " on server " + server.getAddress());
    }

    static View findViewInProject(Project project, String viewname) throws StarTeamSCMException {
        for (View view : project.getAccessibleViews()) {
            if (!view.getName().equals(viewname)) continue;
            return view;
        }
        throw new StarTeamSCMException("Couldn't find view " + viewname + " in project " + project.getName());
    }

    public void close() {
        if (this.server.isConnected()) {
            if (this.rootFolder != null) {
                this.rootFolder.getTypeNames().getClass();
                this.rootFolder.discardItems("File", -1);
            }
            this.view.discard();
            this.project.discard();
            this.server.disconnect();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        StarTeamConnection other = (StarTeamConnection)object;
        return this.port == other.port && this.hostName.equals(other.hostName) && this.userName.equals(other.userName) && this.password.equals(other.password) && this.projectName.equals(other.projectName) && this.viewName.equals(other.viewName) && this.folderName.equals(other.folderName);
    }

    public int hashCode() {
        return this.userName.hashCode();
    }

    public String toString() {
        return "host: " + this.hostName + ", port: " + Integer.toString(this.port) + ", user: " + this.userName + ", passwd: ******, project: " + this.projectName + ", view: " + this.viewName + ", folder: " + this.folderName;
    }

    public StarTeamChangeSet computeChangeSet(Folder rootFolder, File workspace, Collection<StarTeamFilePoint> historicFilePoints, PrintStream logger) throws StarTeamSCMException, IOException {
        Collection starteamFiles = StarTeamFunctions.listAllFiles((Folder)rootFolder, (File)workspace);
        Map starteamFileMap = StarTeamFunctions.convertToFileMap((Collection)starteamFiles);
        Set starteamFileSet = starteamFileMap.keySet();
        Collection starteamFilePoint = StarTeamFilePointFunctions.convertFilePointCollection((Collection)starteamFiles);
        Collection fileSystemFiles = StarTeamFilePointFunctions.listAllFiles((File)workspace);
        TreeSet fileSystemRemove = new TreeSet(fileSystemFiles);
        fileSystemRemove.removeAll(starteamFileSet);
        StarTeamChangeSet changeSet = new StarTeamChangeSet();
        changeSet.setFilesToCheckout(starteamFiles);
        changeSet.setFilesToRemove(fileSystemRemove);
        changeSet.setFilePointsToRemember(starteamFilePoint);
        if (historicFilePoints != null && !historicFilePoints.isEmpty()) {
            try {
                changeSet.setComparisonAvailable(true);
                this.computeDifference(starteamFilePoint, historicFilePoints, changeSet, starteamFileMap);
            }
            catch (Throwable t) {
                t.printStackTrace(logger);
            }
        } else {
            for (com.starbase.starteam.File file : starteamFiles) {
                changeSet.addChange(this.FileToStarTeamChangeLogEntry(file));
            }
        }
        return changeSet;
    }

    public StarTeamChangeLogEntry FileToStarTeamChangeLogEntry(com.starbase.starteam.File f) {
        return this.FileToStarTeamChangeLogEntry(f, "change");
    }

    public StarTeamChangeLogEntry FileToStarTeamChangeLogEntry(com.starbase.starteam.File f, String change) {
        int revisionNumber = f.getContentVersion();
        int userId = f.getModifiedBy();
        String username = this.getUsername(userId);
        String msg = f.getComment();
        Date date = new Date(f.getModifiedTime().getLongValue());
        String fileName = f.getName();
        return new StarTeamChangeLogEntry(fileName, revisionNumber, date, username, msg, change);
    }

    public StarTeamChangeSet computeDifference(Collection<StarTeamFilePoint> currentFilePoint, Collection<StarTeamFilePoint> historicFilePoint, StarTeamChangeSet changeSet, Map<File, com.starbase.starteam.File> starteamFileMap) {
        Map starteamFilePointMap = StarTeamFilePointFunctions.convertToFilePointMap(currentFilePoint);
        Map historicFilePointMap = StarTeamFilePointFunctions.convertToFilePointMap(historicFilePoint);
        HashSet starteamOnly = new HashSet();
        starteamOnly.addAll(starteamFilePointMap.keySet());
        starteamOnly.removeAll(historicFilePointMap.keySet());
        HashSet historicOnly = new HashSet();
        historicOnly.addAll(historicFilePointMap.keySet());
        historicOnly.removeAll(starteamFilePointMap.keySet());
        HashSet common = new HashSet();
        common.addAll(starteamFilePointMap.keySet());
        common.removeAll(starteamOnly);
        HashSet<File> higher = new HashSet<File>();
        HashSet<File> lower = new HashSet<File>();
        for (File f : common) {
            StarTeamFilePoint starteam = (StarTeamFilePoint)starteamFilePointMap.get(f);
            StarTeamFilePoint historic = (StarTeamFilePoint)historicFilePointMap.get(f);
            if (starteam.getRevisionNumber() == historic.getRevisionNumber()) continue;
            com.starbase.starteam.File stf = starteamFileMap.get(f);
            if (starteam.getRevisionNumber() > historic.getRevisionNumber()) {
                higher.add(f);
                changeSet.addChange(this.FileToStarTeamChangeLogEntry(stf, "change"));
            }
            if (starteam.getRevisionNumber() >= historic.getRevisionNumber()) continue;
            lower.add(f);
            changeSet.addChange(this.FileToStarTeamChangeLogEntry(stf, "rollback"));
        }
        for (File f : historicOnly) {
            StarTeamFilePoint historic = (StarTeamFilePoint)historicFilePointMap.get(f);
            StarTeamChangeLogEntry change = new StarTeamChangeLogEntry(f.getName(), historic.getRevisionNumber(), new Date(), "", "", "removed");
            changeSet.addChange(change);
        }
        for (File f : starteamOnly) {
            com.starbase.starteam.File stf = starteamFileMap.get(f);
            changeSet.addChange(this.FileToStarTeamChangeLogEntry(stf, "added"));
        }
        return changeSet;
    }
}

