/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.starteam.StarTeamChangeLogParser;
import hudson.plugins.starteam.StarTeamCheckoutActor;
import hudson.plugins.starteam.StarTeamPollingActor;
import hudson.plugins.starteam.StarTeamSCM;
import hudson.plugins.starteam.StarTeamViewSelector;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import org.kohsuke.stapler.DataBoundConstructor;

public class StarTeamSCM
extends SCM {
    @Extension
    public static final StarTeamSCMDescriptorImpl DESCRIPTOR = new StarTeamSCMDescriptorImpl();
    private final String user;
    private final String passwd;
    private final String projectname;
    private final String viewname;
    private final String foldername;
    private final String hostname;
    private final int port;
    private final String labelname;
    private final boolean promotionstate;
    private final StarTeamViewSelector config;

    @DataBoundConstructor
    public StarTeamSCM(String hostname, int port, String projectname, String viewname, String foldername, String username, String password, String labelname, boolean promotionstate) {
        this.hostname = hostname;
        this.port = port;
        this.projectname = projectname;
        this.viewname = viewname;
        this.foldername = foldername;
        this.user = username;
        this.passwd = password;
        this.labelname = labelname;
        this.promotionstate = promotionstate;
        StarTeamViewSelector result = null;
        if (this.labelname != null && !this.labelname.isEmpty()) {
            try {
                result = this.promotionstate ? new StarTeamViewSelector(this.labelname, "Promotion") : new StarTeamViewSelector(this.labelname, "Label");
            }
            catch (ParseException e) {
                e.printStackTrace();
                result = null;
            }
        }
        this.config = result;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean status = false;
        FilePath changeLogFilePath = new FilePath(changelogFile);
        StarTeamCheckoutActor co_actor = new StarTeamCheckoutActor(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername, this.config, changeLogFilePath, listener, build);
        if (((Boolean)workspace.act((FilePath.FileCallable)co_actor)).booleanValue()) {
            status = true;
        } else {
            listener.getLogger().println("StarTeam checkout failed");
            status = false;
        }
        return status;
    }

    public ChangeLogParser createChangeLogParser() {
        return new StarTeamChangeLogParser();
    }

    public StarTeamSCMDescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean pollChanges(AbstractProject proj, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        boolean status = false;
        AbstractBuild lastBuild = (AbstractBuild)proj.getLastBuild();
        StarTeamPollingActor p_actor = new StarTeamPollingActor(this.hostname, this.port, this.user, this.passwd, this.projectname, this.viewname, this.foldername, this.config, listener, lastBuild);
        if (((Boolean)workspace.act((FilePath.FileCallable)p_actor)).booleanValue()) {
            status = true;
        } else {
            listener.getLogger().println("StarTeam polling shows no changes");
        }
        return status;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getProjectname() {
        return this.projectname;
    }

    public String getViewname() {
        return this.viewname;
    }

    public String getFoldername() {
        return this.foldername;
    }

    public String getUsername() {
        return this.user;
    }

    public String getPassword() {
        return this.passwd;
    }

    public String getLabelname() {
        return this.labelname;
    }

    public boolean isPromotionstate() {
        return this.promotionstate;
    }
}

