/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import hudson.plugins.starteam.StarTeamFilePoint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarTeamFilePointFunctions {
    public static Collection<File> convertToFileCollection(Collection<com.starbase.starteam.File> collection) {
        ArrayList<File> result = new ArrayList<File>();
        for (com.starbase.starteam.File f : collection) {
            result.add(new File(f.getFullName()));
        }
        return result;
    }

    public static Collection<StarTeamFilePoint> convertFilePointCollection(Collection<com.starbase.starteam.File> collection) throws IOException {
        ArrayList<StarTeamFilePoint> result = new ArrayList<StarTeamFilePoint>();
        for (com.starbase.starteam.File f : collection) {
            result.add(new StarTeamFilePoint(f));
        }
        return result;
    }

    public static Collection<StarTeamFilePoint> extractFilePointSubCollection(Map<File, StarTeamFilePoint> map, Collection<File> collection) {
        ArrayList<StarTeamFilePoint> result = new ArrayList<StarTeamFilePoint>();
        for (File f : collection) {
            result.add(map.get(f));
        }
        return result;
    }

    public static Collection<com.starbase.starteam.File> extractFileSubCollection(Map<File, com.starbase.starteam.File> map, Collection<File> collection) {
        ArrayList<com.starbase.starteam.File> result = new ArrayList<com.starbase.starteam.File>();
        for (File f : collection) {
            result.add(map.get(f));
        }
        return result;
    }

    public static Map<File, StarTeamFilePoint> convertToFilePointMap(Collection<StarTeamFilePoint> collection) {
        HashMap<File, StarTeamFilePoint> result = new HashMap<File, StarTeamFilePoint>();
        for (StarTeamFilePoint fp : collection) {
            result.put(fp.getFile(), fp);
        }
        return result;
    }

    public static Collection<File> listAllFiles(File workspace) {
        ArrayList<File> result = new ArrayList<File>();
        StarTeamFilePointFunctions.listAllFiles(result, workspace.getAbsoluteFile());
        return result;
    }

    private static void listAllFiles(Collection<File> result, File dir) {
        ArrayList<File> sub = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isFile()) {
                    result.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                sub.add(f);
            }
            for (File f : sub) {
                StarTeamFilePointFunctions.listAllFiles(result, f);
            }
        } else if (dir.isFile()) {
            result.add(dir);
        }
    }

    public static Collection<StarTeamFilePoint> loadCollection(File file) throws IOException {
        List stringCollection = FileUtils.readLines((File)file, (String)"ISO-8859-1");
        ArrayList<StarTeamFilePoint> result = new ArrayList<StarTeamFilePoint>();
        for (String str : stringCollection) {
            int pos = str.indexOf(44);
            String revision = str.substring(0, pos);
            String path = str.substring(pos + 1);
            StarTeamFilePoint f = new StarTeamFilePoint(path, Integer.parseInt(revision));
            result.add(f);
        }
        FileUtils.writeLines((File)file, (String)"ISO-8859-1", (Collection)stringCollection);
        return result;
    }

    public static void storeCollection(File file, Collection<StarTeamFilePoint> collection) throws IOException {
        ArrayList<String> stringCollection = new ArrayList<String>();
        for (StarTeamFilePoint i : collection) {
            stringCollection.add(i.getRevisionNumber() + "," + i.getFullfilepath());
        }
        FileUtils.writeLines((File)file, (String)"ISO-8859-1", stringCollection);
    }
}

