/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.View;
import hudson.plugins.starteam.StarTeamSCMException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarTeamFunctions {
    public static Folder findFolderInView(View view, String foldername) throws StarTeamSCMException {
        if (view.getName().equalsIgnoreCase(foldername)) {
            return view.getRootFolder();
        }
        File thefolder = new File(foldername.toLowerCase());
        Folder result = StarTeamFunctions.findFolderInView(view.getRootFolder(), thefolder);
        if (result == null) {
            throw new StarTeamSCMException("Couldn't find folder " + foldername + " in view " + view.getName());
        }
        return result;
    }

    private static Folder findFolderInView(Folder folder, File thefolder) {
        ArrayList<Folder> checkLater = new ArrayList<Folder>();
        for (Folder f : folder.getSubFolders()) {
            if (f.getFolderHierarchy().equalsIgnoreCase(thefolder.getPath() + File.separator)) {
                return f;
            }
            checkLater.add(f);
        }
        for (Folder f : checkLater) {
            Folder result = StarTeamFunctions.findFolderInView(f, thefolder);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Collection<com.starbase.starteam.File> listAllFiles(Map<String, Folder> rootFolderMap, File workspace) {
        ArrayList<com.starbase.starteam.File> result = new ArrayList<com.starbase.starteam.File>();
        for (Map.Entry<String, Folder> f : rootFolderMap.entrySet()) {
            result.addAll(StarTeamFunctions.listAllFiles(f.getValue(), workspace));
        }
        return result;
    }

    public static Collection<com.starbase.starteam.File> listAllFiles(Folder rootFolder, File workspace) {
        ArrayList<com.starbase.starteam.File> result = new ArrayList<com.starbase.starteam.File>();
        String alternatePath = rootFolder.getAlternatePathFragment();
        if (alternatePath == null) {
            alternatePath = "";
        }
        File actualPlace = new File(workspace, alternatePath);
        rootFolder.setAlternatePathFragment(actualPlace.getAbsolutePath());
        StarTeamFunctions.listAllFiles(result, rootFolder);
        return result;
    }

    private static void listAllFiles(Collection<com.starbase.starteam.File> result, Folder folder) {
        for (Folder folder2 : folder.getSubFolders()) {
            StarTeamFunctions.listAllFiles(result, folder2);
        }
        folder.getView().getProject().getServer().getTypeNames().getClass();
        for (Folder folder3 : folder.getItems("File")) {
            com.starbase.starteam.File f = (com.starbase.starteam.File)folder3;
            try {
                result.add(f);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        folder.discard();
    }

    public static Map<String, String> splitCsvString(String multiplefolder) {
        HashMap<String, String> folderMap = new HashMap<String, String>();
        if (multiplefolder != null) {
            for (String folderLine : multiplefolder.split("\n")) {
                String workspacePath;
                String folderLineNullable = StringUtils.trimToNull((String)folderLine);
                if (folderLineNullable == null) continue;
                String[] starteamWorkspace = folderLineNullable.split(",");
                String starteamFolder = starteamWorkspace.length > 0 ? StringUtils.trimToNull((String)starteamWorkspace[0]) : null;
                String string = workspacePath = starteamWorkspace.length > 1 ? StringUtils.trimToNull((String)starteamWorkspace[1]) : null;
                if (workspacePath == null) {
                    workspacePath = ".";
                }
                if (starteamFolder == null || workspacePath == null) continue;
                folderMap.put(starteamFolder, workspacePath);
            }
        }
        return folderMap;
    }

    public static Map<File, com.starbase.starteam.File> convertToFileMap(Collection<com.starbase.starteam.File> collection) {
        TreeMap<File, com.starbase.starteam.File> result = new TreeMap<File, com.starbase.starteam.File>();
        for (com.starbase.starteam.File f : collection) {
            result.put(new File(f.getFullName()), f);
        }
        return result;
    }
}

