/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.http;

import icu.clemon.jcommon.exception.APIException;
import icu.clemon.jcommon.http.ResultCode;
import icu.clemon.jcommon.json.EnumeratorSerializers;
import icu.clemon.jcommon.types.Enumerator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class EnumeratorConverter
implements ConditionalGenericConverter {
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return Enumerator.class.isAssignableFrom(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> s = new HashSet<GenericConverter.ConvertiblePair>();
        s.add(new GenericConverter.ConvertiblePair(String.class, Enumerator.class));
        s.add(new GenericConverter.ConvertiblePair(Integer.TYPE, Enumerator.class));
        return s;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        assert (source != null);
        AtomicInteger id = new AtomicInteger();
        try {
            id.set(Integer.parseInt(source.toString()));
        }
        catch (NumberFormatException e) {
            throw new APIException(ResultCode.IllegalArgument, String.format("failed convert value %s to type %s", source, targetType.getName()));
        }
        return EnumeratorSerializers.Deserializer.getActualEnumerator(targetType.getType().asSubclass(Enumerator.class), id.get());
    }
}

