/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.core.Ordered;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class CommonJackson2ObjectMapperBuilderCustomizer
implements Jackson2ObjectMapperBuilderCustomizer,
Ordered {
    public static String dateFormat = "yyyy-MM-dd HH:mm:ss";

    public void customize(Jackson2ObjectMapperBuilder builder) {
        builder.serializationInclusion(JsonInclude.Include.NON_NULL);
        builder.serializationInclusion(JsonInclude.Include.NON_EMPTY);
        builder.failOnUnknownProperties(false);
        builder.propertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        builder.simpleDateFormat(dateFormat);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(dateFormat)));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern(dateFormat)));
        builder.modulesToInstall(new Module[]{javaTimeModule});
        builder.featuresToEnable(new Object[]{SerializationFeature.WRITE_ENUMS_USING_INDEX});
        builder.featuresToEnable(new Object[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING});
        builder.featuresToEnable(new Object[]{SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS});
        builder.featuresToDisable(new Object[]{SerializationFeature.FAIL_ON_EMPTY_BEANS});
        builder.featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT});
        builder.featuresToEnable(new Object[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
    }

    public int getOrder() {
        return 1;
    }
}

