/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.json;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import icu.clemon.jcommon.exception.APIException;
import icu.clemon.jcommon.http.ResultCode;
import icu.clemon.jcommon.types.Enumerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class EnumeratorSerializers {

    public static class Deserializer
    extends JsonDeserializer<Enumerator>
    implements ContextualDeserializer {
        private final Class<? extends Enumerator> propertyClass;

        public Deserializer() {
            this.propertyClass = null;
        }

        public Deserializer(Class<? extends Enumerator> propertyClass) {
            this.propertyClass = propertyClass;
        }

        public Enumerator getTargetEnumerator(int id) {
            assert (this.propertyClass != null);
            return Arrays.stream(this.propertyClass.getEnumConstants()).filter(e -> e.getId() == id).findAny().orElseThrow(() -> new APIException(ResultCode.CODEIllegalArgument, "bad id for " + this.propertyClass.getSimpleName()));
        }

        public Enumerator deserialize(JsonParser p, DeserializationContext ctx) throws IOException, JacksonException {
            assert (this.propertyClass != null);
            AtomicInteger id = new AtomicInteger();
            try {
                id.set(p.getIntValue());
            }
            catch (IOException ex) {
                try {
                    id.set(Integer.parseInt(p.getText()));
                }
                catch (IOException | NumberFormatException exx) {
                    throw new APIException(ResultCode.CODEIllegalArgument, "bad id for " + this.propertyClass.getSimpleName());
                }
            }
            return this.getTargetEnumerator(id.get());
        }

        public JsonDeserializer<Enumerator> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            Class rawClass = property.getType().getRawClass();
            if (Enumerator.class.isAssignableFrom(rawClass) && Enum.class.isAssignableFrom(rawClass)) {
                return new Deserializer(rawClass.asSubclass(Enumerator.class));
            }
            return null;
        }
    }

    public static class Serializer
    extends JsonSerializer<Enumerator> {
        public void serialize(Enumerator value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNumber(value.getId().intValue());
        }
    }
}

