/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.route;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.springframework.web.bind.annotation.RequestMethod;

public class Route {
    private String className = "";
    private String methodName = "";
    private Set<String> patterns = new HashSet<String>();
    private Set<RequestMethod> methods = new HashSet<RequestMethod>();

    public String getTraefikRule() {
        LinkedList pathRules = new LinkedList();
        LinkedList methodRules = new LinkedList();
        this.patterns.forEach(pattern -> pathRules.add(String.format("`%s`", pattern)));
        this.methods.forEach(method -> methodRules.add(String.format("`%s`", method.name())));
        StringBuilder builder = new StringBuilder(String.format("traefik.http.routers.%s_%s.rule=", this.className, this.methodName));
        if (!pathRules.isEmpty()) {
            builder.append(String.format("Path(%s)", String.join((CharSequence)",", pathRules)));
        }
        if (!methodRules.isEmpty()) {
            builder.append(String.format(" && Method(%s)", String.join((CharSequence)",", methodRules)));
        }
        return builder.toString();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setPatterns(Set<String> patterns) {
        this.patterns = patterns;
    }

    public void setMethods(Set<RequestMethod> methods) {
        this.methods = methods;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Route)) {
            return false;
        }
        Route other = (Route)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        Set<String> this$patterns = this.getPatterns();
        Set<String> other$patterns = other.getPatterns();
        if (this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns)) {
            return false;
        }
        Set<RequestMethod> this$methods = this.getMethods();
        Set<RequestMethod> other$methods = other.getMethods();
        return !(this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Route;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        Set<String> $patterns = this.getPatterns();
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        Set<RequestMethod> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        return result;
    }

    public String toString() {
        return "Route(className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", patterns=" + this.getPatterns() + ", methods=" + this.getMethods() + ")";
    }
}

