/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.exception;

import icu.clemon.jcommon.exception.APIException;
import icu.clemon.jcommon.http.Result;
import icu.clemon.jcommon.http.ResultCode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={APIException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> APIExceptionHandler(Exception e) {
        if (e instanceof APIException) {
            APIException ex = (APIException)e;
            log.error("API error:\n");
            e.printStackTrace();
            return Result.error(ex);
        }
        log.error("Uncached API error:\n");
        e.printStackTrace();
        return Result.error(ResultCode.CODE500.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> MethodArgumentTypeMismatchExceptionHandler(MethodArgumentTypeMismatchException ex) {
        String error = String.format("%s should be of type %s", ex.getName(), ex.getRequiredType().getName());
        ex.printStackTrace();
        return Result.error(ResultCode.CODE500.getCode(), error);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result<Object> BindExceptionHandler(BindException ex) throws NoSuchFieldException {
        String error = String.format("%s is not an allowed value for field %s", ex.getFieldError().getRejectedValue(), ex.getFieldError().getField());
        log.error("Binding exception:\n");
        ex.printStackTrace();
        return Result.error(ResultCode.CODE500.getCode(), error);
    }

    @ExceptionHandler(value={NullPointerException.class})
    public Result<String> nullPointerExceptionHandler(NullPointerException e) {
        log.error("NullPointer error:");
        e.printStackTrace();
        return Result.error(ResultCode.CODE500.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public Result<String> UnknownHandler(Exception e) {
        log.error("Unknown error:\n");
        e.printStackTrace();
        return Result.error(ResultCode.CODE500.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result<Object> HttpMessageNotReadableExceptionHandler(Exception e) {
        HttpMessageNotReadableException ex;
        Throwable throwable;
        if (e instanceof HttpMessageNotReadableException && (throwable = (ex = (HttpMessageNotReadableException)e).getRootCause()) instanceof APIException) {
            APIException exx = (APIException)throwable;
            log.error("API error:\n");
            e.printStackTrace();
            return Result.error(exx);
        }
        log.error("Http message NotReadable error:\n");
        e.printStackTrace();
        return Result.error(ResultCode.CODE400.getCode(), e.getMessage());
    }
}

