/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import icu.clemon.jcommon.config.JcommonConfig;
import icu.clemon.jcommon.exception.APIException;
import icu.clemon.jcommon.http.ResultCode;
import icu.clemon.jcommon.types.Enumerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class EnumeratorSerializers {

    public static class Deserializer
    extends JsonDeserializer<Enumerator>
    implements ContextualDeserializer {
        private final Class<? extends Enumerator> propertyClass;

        public Deserializer() {
            this.propertyClass = null;
        }

        public Deserializer(Class<? extends Enumerator> propertyClass) {
            this.propertyClass = propertyClass;
        }

        public static Enumerator getActualEnumerator(Class<? extends Enumerator> clz, int id) {
            return Arrays.stream(clz.getEnumConstants()).filter(e -> e.getId() == id).findAny().orElseThrow(() -> new APIException(ResultCode.CODEIllegalArgument, String.format("failed convert value %s to type %s", id, clz.getName())));
        }

        public Enumerator deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            assert (this.propertyClass != null);
            AtomicInteger id = new AtomicInteger();
            try {
                id.set(p.getIntValue());
            }
            catch (IOException ex) {
                try {
                    id.set(Integer.parseInt(p.getText()));
                }
                catch (IOException | NumberFormatException exx) {
                    throw new APIException(ResultCode.CODEIllegalArgument, String.format("failed convert value %s to type %s", p.getText(), this.propertyClass.getName()));
                }
            }
            return Deserializer.getActualEnumerator(this.propertyClass, id.get());
        }

        public JsonDeserializer<Enumerator> createContextual(DeserializationContext ctx, BeanProperty property) {
            assert (property != null);
            Class rawClass = property.getType().getRawClass();
            if (Enumerator.class.isAssignableFrom(rawClass) && Enum.class.isAssignableFrom(rawClass)) {
                return new Deserializer(rawClass.asSubclass(Enumerator.class));
            }
            return null;
        }
    }

    public static class Serializer
    extends JsonSerializer<Enumerator> {
        private final JcommonConfig config;

        public void serialize(Enumerator value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (this.config.getEnumerator().isSerializeWithDesc()) {
                gen.writeStartObject();
                gen.writeNumberField("id", value.getId().intValue());
                gen.writeStringField("desc", value.getDescription());
                gen.writeEndObject();
            } else {
                gen.writeNumber(value.getId().intValue());
            }
        }

        @Generated
        public Serializer(JcommonConfig config) {
            this.config = config;
        }
    }
}

