/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.route;

import icu.clemon.jcommon.route.Route;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;

public class RouteService {
    private final WebApplicationContext webApplicationContext;

    public List<Route> getRoutes() {
        LinkedList<Route> routes = new LinkedList<Route>();
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.webApplicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map methods = mapping.getHandlerMethods();
        for (Map.Entry method : methods.entrySet()) {
            RequestMappingInfo info = (RequestMappingInfo)method.getKey();
            PathPatternsRequestCondition patternsCondition = info.getPathPatternsCondition();
            RequestMethodsRequestCondition methodsCondition = info.getMethodsCondition();
            if (patternsCondition == null) continue;
            Route route = new Route();
            Set patterns = patternsCondition.getPatterns();
            route.setPatterns(patterns.stream().map(PathPattern::getPatternString).filter(p -> !"/error".equals(p)).collect(Collectors.toSet()));
            if (route.getPatterns().isEmpty()) continue;
            route.setClassName(((HandlerMethod)method.getValue()).getMethod().getDeclaringClass().getSimpleName());
            route.setMethodName(((HandlerMethod)method.getValue()).getMethod().getName());
            route.setMethods(methodsCondition.getMethods());
            routes.add(route);
        }
        return routes;
    }

    @Generated
    public RouteService(WebApplicationContext webApplicationContext) {
        this.webApplicationContext = webApplicationContext;
    }
}

