/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;

public class Utils {
    public static void getFields(List<Field> fields, Class<?> clazz) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            Utils.getFields(fields, superClazz);
        }
    }

    public static List<Field> getFieldsDeep(Class<?> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        Utils.getFields(fields, clazz);
        return fields;
    }

    public static <T> T merge(T local, T remote) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = local.getClass();
        Object merged = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field field : Utils.getFieldsDeep(clazz)) {
            field.setAccessible(true);
            Object remoteField = field.get(remote);
            if (remoteField == null) continue;
            Class<String> clz = remoteField.getClass();
            if (ClassUtils.isPrimitiveOrWrapper(clz) || clz.isAssignableFrom(String.class)) {
                field.set(merged, remoteField);
                continue;
            }
            Object localField = field.get(local);
            field.set(merged, localField != null ? Utils.merge(localField, remoteField) : remoteField);
        }
        return (T)merged;
    }
}

