/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import icu.clemon.jcommon.route.RouteService;
import java.util.LinkedList;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;

public class ServiceRegistry
extends ConsulServiceRegistry {
    private final RouteService routeService;
    private final String appName;

    public ServiceRegistry(ConsulClient client, ConsulDiscoveryProperties properties, TtlScheduler ttlScheduler, HeartbeatProperties heartbeatProperties, String appName, RouteService routeService) {
        super(client, properties, ttlScheduler, heartbeatProperties);
        this.routeService = routeService;
        this.appName = appName;
    }

    public void register(ConsulRegistration reg) {
        NewService svc = reg.getService();
        LinkedList<String> tags = new LinkedList<String>();
        tags.add("traefik.enable=true");
        this.routeService.getRoutes().forEach(route -> tags.add(route.getTraefikRule()));
        svc.setTags(tags);
        svc.setName(this.appName);
        super.register(reg);
    }
}

