/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import icu.clemon.jcommon.http.Result;
import icu.clemon.jcommon.http.ResultCode;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class PageResult<T>
extends Result<List<T>>
implements Serializable {
    private final long totalItem;
    private final long totalPage;
    private final long size;
    private final long page;
    @JsonIgnore
    private final long offset;

    public PageResult(List<T> content, Pageable pageable, long totalItem) {
        this.size = pageable.getPageSize();
        this.page = pageable.getPageNumber();
        this.totalItem = totalItem;
        this.totalPage = (this.totalItem + this.size - 1L) / this.size;
        this.offset = this.page >= this.totalPage ? this.totalItem : pageable.getOffset();
        this.setData(content);
        this.setCode(ResultCode.OK.getCode());
        this.setTs(System.currentTimeMillis());
    }

    public static <T> PageResult<T> of(List<T> content, Pageable pageable, long total) {
        return new PageResult<T>(content, pageable, total);
    }

    public static <T> PageResult<T> of(Page<T> page) {
        return PageResult.of(page.getContent(), page.getPageable(), page.getTotalElements());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResult)) {
            return false;
        }
        PageResult other = (PageResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTotalItem() != other.getTotalItem()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        return this.getOffset() == other.getOffset();
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $totalItem = this.getTotalItem();
        result = result * 59 + (int)($totalItem >>> 32 ^ $totalItem);
        long $totalPage = this.getTotalPage();
        result = result * 59 + (int)($totalPage >>> 32 ^ $totalPage);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $page = this.getPage();
        result = result * 59 + (int)($page >>> 32 ^ $page);
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        return result;
    }

    @Generated
    public long getTotalItem() {
        return this.totalItem;
    }

    @Generated
    public long getTotalPage() {
        return this.totalPage;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public long getPage() {
        return this.page;
    }

    @Generated
    public long getOffset() {
        return this.offset;
    }

    @Override
    @Generated
    public String toString() {
        return "PageResult(totalItem=" + this.getTotalItem() + ", totalPage=" + this.getTotalPage() + ", size=" + this.getSize() + ", page=" + this.getPage() + ", offset=" + this.getOffset() + ")";
    }
}

