/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.http;

import com.google.common.base.CaseFormat;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=-2147483648)
@Component
public class HttpGetSnakeCaseConverter
extends OncePerRequestFilter {
    protected boolean shouldNotFilter(HttpServletRequest request) {
        return !request.getMethod().equalsIgnoreCase(RequestMethod.GET.name());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        final ConcurrentHashMap<String, String[]> formattedParams = new ConcurrentHashMap<String, String[]>();
        for (String param : request.getParameterMap().keySet()) {
            String formattedParam = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, param);
            formattedParams.put(formattedParam, request.getParameterValues(param));
        }
        filterChain.doFilter((ServletRequest)new HttpServletRequestWrapper(request){

            public String getParameter(String name) {
                return formattedParams.containsKey(name) ? ((String[])formattedParams.get(name))[0] : null;
            }

            public Enumeration<String> getParameterNames() {
                return Collections.enumeration(formattedParams.keySet());
            }

            public String[] getParameterValues(String name) {
                return (String[])formattedParams.get(name);
            }

            public Map<String, String[]> getParameterMap() {
                return formattedParams;
            }
        }, (ServletResponse)response);
    }
}

