/*
 * Decompiled with CFR 0.152.
 */
package icu.clemon.jcommon.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import icu.clemon.jcommon.exception.APIException;
import icu.clemon.jcommon.http.ResultCode;
import java.io.Serializable;
import lombok.Generated;

public class Result<T>
implements Serializable {
    private String msg;
    private int code;
    private long ts = System.currentTimeMillis();
    private T data;

    public static <T> Result<T> success(int code, String msg, T data) {
        Result<T> r = new Result<T>();
        r.setCode(code);
        r.setMsg(msg);
        r.setData(data);
        return r;
    }

    public static <T> Result<T> success() {
        return Result.success(ResultCode.HTTP200.getCode(), null, null);
    }

    public static <T> Result<T> success(T data) {
        return Result.success(ResultCode.OK.getCode(), null, data);
    }

    public static <T> Result<T> success(int code) {
        return Result.success(code, null, null);
    }

    public static <T> Result<T> success(int code, String msg) {
        return Result.success(code, msg, null);
    }

    public static <T> Result<T> error(int code, String msg, T data) {
        Result<T> r = new Result<T>();
        r.setCode(code);
        r.setMsg(msg);
        r.setData(data);
        return r;
    }

    public static <T> Result<T> error() {
        return Result.error(ResultCode.HTTP400.getCode(), null, null);
    }

    public static <T> Result<T> error(int code) {
        return Result.error(code, null, null);
    }

    public static <T> Result<T> error(APIException e) {
        return Result.error(e.getCode(), e.getMessage());
    }

    public static <T> Result<T> error(int code, String msg) {
        return Result.error(code, msg, null);
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public long getTs() {
        return this.ts;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Generated
    public void setCode(int code) {
        this.code = code;
    }

    @Generated
    public void setTs(long ts) {
        this.ts = ts;
    }

    @Generated
    public void setData(T data) {
        this.data = data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

