/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator;

import icu.congee.id.generator.uuid.UUIDv1Generator;
import icu.congee.id.generator.uuid.UUIDv2Generator;
import icu.congee.id.generator.uuid.UUIDv3Generator;
import icu.congee.id.generator.uuid.UUIDv4Generator;
import icu.congee.id.generator.uuid.UUIDv5Generator;
import icu.congee.id.generator.uuid.UUIDv6Generator;
import icu.congee.id.generator.uuid.UUIDv7Generator;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1, warmups=0)
@Threads(value=16)
public class IdGeneratorBenchmark {
    SecureRandom random = new SecureRandom();

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(IdGeneratorBenchmark.class.getSimpleName()).forks(1).warmupIterations(1).measurementIterations(1).build();
        new Runner(opt).run();
    }

    @Benchmark
    public void testUUIDv1() {
        UUIDv1Generator.next();
    }

    @Benchmark
    public void testUUIDv2() {
        UUIDv2Generator.next();
    }

    @Benchmark
    public void testUUIDv3() {
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        UUIDv3Generator.fromNamespaceAndName((UUID)UUID.randomUUID(), (String)Arrays.toString(bytes));
    }

    @Benchmark
    public void testUUIDv4() {
        UUIDv4Generator.next();
    }

    @Benchmark
    public void testUUIDv5() {
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        UUIDv5Generator.fromNamespaceAndName((UUID)UUID.randomUUID(), (String)Arrays.toString(bytes));
    }

    @Benchmark
    public void testUUIDv6() {
        UUIDv6Generator.next();
    }

    @Benchmark
    public void testUUIDv7() {
        UUIDv7Generator.next();
    }
}

