/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator;

import com.google.common.io.BaseEncoding;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Thread)
@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
public class Base64Benchmark {
    private byte[] TEST_BYTES;

    @Setup
    public void setup() {
        this.TEST_BYTES = new byte[16];
        new SecureRandom().nextBytes(this.TEST_BYTES);
    }

    @Benchmark
    public String jdkBase64Encode() {
        return java.util.Base64.getEncoder().encodeToString(this.TEST_BYTES);
    }

    @Benchmark
    public String commonsBase64Encode() {
        return Base64.encodeBase64String((byte[])this.TEST_BYTES);
    }

    @Benchmark
    public String hutoolBase64Encode() {
        return cn.hutool.core.codec.Base64.encode((byte[])this.TEST_BYTES);
    }

    @Benchmark
    public String guavaBase64Encode() {
        return BaseEncoding.base64().encode(this.TEST_BYTES);
    }

    @Benchmark
    public String nettyBase64Encode() {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])this.TEST_BYTES);
        try {
            String string = io.netty.handler.codec.base64.Base64.encode((ByteBuf)buf).toString(StandardCharsets.UTF_8);
            return string;
        }
        finally {
            buf.release();
        }
    }

    @Benchmark
    public byte[] jdkBase64Decode() {
        String encoded = java.util.Base64.getEncoder().encodeToString(this.TEST_BYTES);
        return java.util.Base64.getDecoder().decode(encoded);
    }

    @Benchmark
    public byte[] commonsBase64Decode() {
        String encoded = Base64.encodeBase64String((byte[])this.TEST_BYTES);
        return Base64.decodeBase64((String)encoded);
    }

    @Benchmark
    public byte[] hutoolBase64Decode() {
        String encoded = cn.hutool.core.codec.Base64.encode((byte[])this.TEST_BYTES);
        return cn.hutool.core.codec.Base64.decode((CharSequence)encoded);
    }

    @Benchmark
    public byte[] guavaBase64Decode() {
        String encoded = BaseEncoding.base64().encode(this.TEST_BYTES);
        return BaseEncoding.base64().decode((CharSequence)encoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public byte[] nettyBase64Decode() {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])this.TEST_BYTES);
        try {
            String encoded = io.netty.handler.codec.base64.Base64.encode((ByteBuf)buf).toString(StandardCharsets.UTF_8);
            byte[] byArray = io.netty.handler.codec.base64.Base64.decode((ByteBuf)Unpooled.wrappedBuffer((byte[])encoded.getBytes())).array();
            return byArray;
        }
        finally {
            buf.release();
        }
    }
}

