/*
 * Decompiled with CFR 0.152.
 */
package icu.congee.id.generator;

import icu.congee.id.generator.distributed.snowflake.LockFreeSnowflakeIdGenerator;
import icu.congee.id.generator.distributed.snowflake.SnowflakeIdGenerator;
import icu.congee.id.generator.distributed.ttsid.TtsIdGenerator;
import icu.congee.id.generator.distributed.ttsid.TtsIdPlusGenerator;
import icu.congee.id.generator.distributed.ttsid.TtsIdProGenerator;
import icu.congee.id.generator.distributed.ttsid.TtsIdProMaxGenerator;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;

@State(value=Scope.Benchmark)
public class CompleteSpringBenchmark {
    @Param(value={"1", "24"})
    private int threadCount;
    public SnowflakeIdGenerator snowflakeIdGenerator;
    public LockFreeSnowflakeIdGenerator lockFreeSnowflakeIdGenerator;
    public ConfigurableApplicationContext context;
    public TtsIdGenerator ttsIdGenerator;
    public TtsIdPlusGenerator ttsIdPlusGenerator;
    public TtsIdProGenerator ttsIdProGenerator;
    public TtsIdProMaxGenerator ttsIdProMaxGenerator;

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(CompleteSpringBenchmark.class.getSimpleName()).timeUnit(TimeUnit.SECONDS).mode(Mode.Throughput).forks(0).warmupIterations(0).warmupTime(TimeValue.seconds((long)0L)).measurementIterations(1).measurementTime(TimeValue.seconds((long)10L)).timeout(TimeValue.seconds((long)15L)).build();
        new Runner(opt).run();
    }

    @Setup(value=Level.Trial)
    public void init() {
        this.context = SpringApplication.run(CompleteSpringBenchmark.class, (String[])new String[0]);
        this.ttsIdGenerator = (TtsIdGenerator)this.context.getBean(TtsIdGenerator.class);
        this.ttsIdPlusGenerator = (TtsIdPlusGenerator)this.context.getBean(TtsIdPlusGenerator.class);
        this.ttsIdProGenerator = (TtsIdProGenerator)this.context.getBean(TtsIdProGenerator.class);
        this.ttsIdProMaxGenerator = (TtsIdProMaxGenerator)this.context.getBean(TtsIdProMaxGenerator.class);
    }

    @TearDown(value=Level.Trial)
    public void close() {
        this.context.close();
    }

    public void generateSnowflake(Blackhole bh) {
        bh.consume((Object)this.snowflakeIdGenerator.generate());
    }

    public void generateLockFreeSnowflake(Blackhole bh) {
        bh.consume((Object)this.lockFreeSnowflakeIdGenerator.generate());
    }

    @Benchmark
    @Threads(value=1)
    public void generateTtsId() {
        this.ttsIdGenerator.generate();
    }

    @Benchmark
    @Threads(value=1)
    public void generateTtsIdPlus() {
        this.ttsIdPlusGenerator.generate();
    }

    @Benchmark
    @Threads(value=1)
    public void generateTtsIdPro() {
        this.ttsIdProGenerator.generate();
    }

    @Benchmark
    @Threads(value=1)
    public void generateTtsIdProMax() {
        this.ttsIdProMaxGenerator.generate();
    }
}

